% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vsp.R
\name{vsp.svd_like}
\alias{vsp.svd_like}
\title{Perform varimax rotation on a low rank matrix factorization}
\usage{
\method{vsp}{svd_like}(
  x,
  rank,
  ...,
  centerer = NULL,
  scaler = NULL,
  recenter = FALSE,
  renormalize = FALSE,
  kaiser_normalize_u = FALSE,
  kaiser_normalize_v = FALSE,
  rownames = NULL,
  colnames = NULL,
  match_columns = TRUE
)
}
\arguments{
\item{x}{Either a graph adjacency matrix, \link[igraph:aaa-igraph-package]{igraph::igraph} or
\link[tidygraph:tbl_graph]{tidygraph::tbl_graph}. If \code{x} is a \link{matrix} or \link[Matrix:Matrix]{Matrix::Matrix}
then \code{x[i, j]} should correspond to the edge going from node \code{i}
to node \code{j}.}

\item{rank}{The number of factors to calculate.}

\item{...}{These dots are for future extensions and must be empty.}

\item{centerer}{TODO}

\item{scaler}{TODO}

\item{recenter}{Should the varimax factors be re-centered around the
original factor means? Only used when \code{center = TRUE}, defaults to \code{FALSE}.}

\item{renormalize}{Should the regularized graph laplacian be used instead of the
raw adjacency matrix? Defaults to \code{TRUE}. If \code{center = TRUE}, \code{A} will
first be centered and then normalized.}

\item{kaiser_normalize_u}{Whether or not to use Kaiser normalization
when rotating the left singular vectors \code{U}. Defaults to \code{FALSE}.}

\item{kaiser_normalize_v}{Whether or not to use Kaiser normalization
when rotating the right singular vectors \code{V}. Defaults to \code{FALSE}.}

\item{rownames}{Character vector of row names of \code{x}. These row names
are propagated into the row names of the \code{U} and \code{Z}. Defaults
to \code{NULL}.}

\item{colnames}{Character vector of column names of \code{x}. These column names
are propagated into the row names of the \code{V} and \code{Y}. Defaults
to \code{NULL}.}

\item{match_columns}{Should the columns of \code{Y} be re-ordered such that
\code{Y[, i]} corresponds to \code{Z[, i]} to the extent possible? Defaults to
\code{TRUE}. Typically helps with interpretation, and often makes \code{B} more
diagonally dominant.}
}
\description{
Perform varimax rotation on a low rank matrix factorization
}
\examples{

library(LRMF3)
library(RSpectra)

s <- svds(ml100k, k = 2)
mf <- as_svd_like(s)
fa <- vsp(mf, rank = 2)

}
