% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_data_fcts.R
\name{Data Examples}
\alias{Data Examples}
\alias{example1}
\alias{example2}
\alias{example3}
\title{Data Examples}
\usage{
example1(p, n, sd, gamma, family = "Gaussian")

example2(p, n, sd, family = "Gaussian")

example3(p, n, sd, gamma, family = "Gaussian")
}
\arguments{
\item{p}{vector length}

\item{n}{sample size}

\item{sd}{standard deviation}

\item{gamma}{polynomial decay of covariance function for \code{example1} resp. exponent for \code{example3}}

\item{family}{distribution of the simulated data. Available distributions are "\code{Gaussian}", "\code{Gamma}", "\code{Uniform}". The default is "\code{Gaussian}".}
}
\value{
A list containing the following elements:
\itemize{
\item{\code{Y}:  }{\code{pxn} dimensional data matrix}
\item{\code{sdf}:   }{true spectral density function}
\item{\code{acf}:   }{true covariance function}
}
}
\description{
\link{example1}, \link{example2} and \link{example3} generate i.i.d. vectors from a given distribution with different Toeplitz covariance matrices.
The covariance function \eqn{\sigma} of the Toeplitz covariance matrix of
\itemize{
\item{\code{example1}: }{has a polynomial decay, \eqn{\sigma(\tau)= sd^2(1+|\tau|)^{-gamma}},}
\item{\code{example2}: }{follows an \eqn{ARMA(2,2)} model with coefficients \eqn{(0.7,-0.4,-0.2,0.2)} and innovations variance \eqn{sd^2},}
\item{\code{example3}: }{yields a Lipschitz continuous spectral density \eqn{f} that is not differentiable, i.e. \eqn{f(x)= sd^2({|\sin(x+0.5\pi)|^{gamma}+0.45})}}
}
}
\examples{
example1(p=10, n=1, sd=1, gamma=1.2, family="Gaussian")
example2(p=10,n=1,sd=1,family="Gaussian")
example3(p=10, n=1, sd=1, gamma=2,family="Gaussian")
}
