% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mult_class.R
\name{mkCrossFrameMExperiment}
\alias{mkCrossFrameMExperiment}
\title{Function to build multi-outcome vtreat cross frame and treatment plan.}
\usage{
mkCrossFrameMExperiment(d, vars, y_name, ...,
  y_dependent_treatments = c("catB"), weights = c(), minFraction = 0.02,
  smFactor = 0, rareCount = 0, rareSig = 1, collarProb = 0,
  codeRestriction = NULL, customCoders = NULL, scale = FALSE,
  doCollar = FALSE, splitFunction = NULL, ncross = 3,
  forceSplit = FALSE, catScaling = FALSE, verbose = FALSE,
  parallelCluster = NULL, use_parallel = TRUE)
}
\arguments{
\item{d}{data to learn from}

\item{vars}{character, vector of indpendent variable column names.}

\item{y_name}{character, name of outcome column.}

\item{...}{not used, declared to forced named binding of later arguments}

\item{y_dependent_treatments}{character what treatment types to build per-outcome level.}

\item{weights}{optional training weights for each row}

\item{minFraction}{optional minimum frequency a categorical level must have to be converted to an indicator column.}

\item{smFactor}{optional smoothing factor for impact coding models.}

\item{rareCount}{optional integer, allow levels with this count or below to be pooled into a shared rare-level.  Defaults to 0 or off.}

\item{rareSig}{optional numeric, suppress levels from pooling at this significance value greater.  Defaults to NULL or off.}

\item{collarProb}{what fraction of the data (pseudo-probability) to collar data at if doCollar is set during \code{\link{prepare.multinomial_plan}}.}

\item{codeRestriction}{what types of variables to produce (character array of level codes, NULL means no restriction).}

\item{customCoders}{map from code names to custom categorical variable encoding functions (please see \url{https://github.com/WinVector/vtreat/blob/master/extras/CustomLevelCoders.md}).}

\item{scale}{optional if TRUE replace numeric variables with regression ("move to outcome-scale").}

\item{doCollar}{optional if TRUE collar numeric variables by cutting off after a tail-probability specified by collarProb during treatment design.}

\item{splitFunction}{(optional) see vtreat::buildEvalSets .}

\item{ncross}{optional scalar>=2 number of cross-validation rounds to design.}

\item{forceSplit}{logical, if TRUE force cross-validated significance calculations on all variables.}

\item{catScaling}{optional, if TRUE use glm() linkspace, if FALSE use lm() for scaling.}

\item{verbose}{if TRUE print progress.}

\item{parallelCluster}{(optional) a cluster object created by package parallel or package snow.}

\item{use_parallel}{logical, if TRUE use parallel methods.}
}
\value{
list(cross_frame, treatments_0, treatments_m)
}
\description{
Please see \code{vignette("MultiClassVtreat", package = "vtreat")} \url{https://winvector.github.io/vtreat/articles/MultiClassVtreat.html}.
}
\seealso{
\code{\link{prepare.multinomial_plan}}
}
