% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vtree.R
\name{vtree}
\alias{vtree}
\title{Draw a variable tree}
\usage{
vtree(
  z,
  vars,
  splitspaces = TRUE,
  prune = list(),
  prunebelow = list(),
  keep = list(),
  follow = list(),
  prunelone = NULL,
  pruneNA = FALSE,
  prunesmaller = NULL,
  labelnode = list(),
  tlabelnode = NULL,
  labelvar = NULL,
  varminwidth = NULL,
  varminheight = NULL,
  varlabelloc = NULL,
  fillcolor = NULL,
  fillnodes = TRUE,
  NAfillcolor = "white",
  rootfillcolor = "#EFF3FF",
  palette = NULL,
  gradient = TRUE,
  revgradient = FALSE,
  singlecolor = 2,
  colorvarlabels = TRUE,
  title = "",
  sameline = FALSE,
  Venn = FALSE,
  check.is.na = FALSE,
  seq = FALSE,
  pattern = FALSE,
  ptable = FALSE,
  showroot = TRUE,
  text = list(),
  ttext = list(),
  plain = FALSE,
  squeeze = 1,
  showvarinnode = FALSE,
  shownodelabels = TRUE,
  showvarnames = TRUE,
  showlevels = TRUE,
  showpct = TRUE,
  showlpct = TRUE,
  showcount = TRUE,
  showlegend = FALSE,
  varnamepointsize = 18,
  HTMLtext = FALSE,
  digits = 0,
  cdigits = 1,
  splitwidth = 20,
  lsplitwidth = 15,
  getscript = FALSE,
  nodesep = 0.5,
  ranksep = 0.5,
  margin = 0.2,
  vp = TRUE,
  horiz = TRUE,
  summary = "",
  runsummary = NULL,
  retain = NULL,
  width = NULL,
  height = NULL,
  graphattr = "",
  nodeattr = "",
  edgeattr = "",
  color = c("blue", "forestgreen", "red", "orange", "pink"),
  colornodes = FALSE,
  mincount = 1,
  maxcount,
  showempty = FALSE,
  rounded = TRUE,
  nodefunc = NULL,
  nodeargs = NULL,
  choicechecklist = TRUE,
  arrowhead = "normal",
  pxwidth,
  pxheight,
  imagewidth,
  imageheight,
  folder,
  pngknit = TRUE,
  as.if.knit = FALSE,
  maxNodes = 1000,
  parent = 1,
  last = 1,
  root = TRUE
)
}
\arguments{
\item{z}{Required: Data frame, or a single vector.}

\item{vars}{Required (unless \code{z} is a vector):
Either a character string of whitespace-separated variable names
or a vector of variable names.}

\item{splitspaces}{When \code{vars} is a character string,
split it by spaces to get variable names?
It is only rarely necessary to use this parameter.
This should only be \code{FALSE} when a single variable name
that contains spaces is specified.}

\item{prune}{List of vectors that specifies nodes to prune.
The name of each element of the
list must be one of the variable names in \code{vars}.
Each element is a vector of character strings that
identifies the values of the variable (i.e. the nodes) to prune.}

\item{prunebelow}{Like \code{prune} but instead of pruning the specified nodes,
their descendants are pruned.}

\item{keep}{Like \code{prune} but specifies which nodes to \emph{keep}.
The other nodes will be pruned.}

\item{follow}{Like \code{keep} but specifies which nodes to "follow",
i.e. which nodes' \emph{descendants} to keep.}

\item{prunelone}{(Deprecated) A vector of values specifying "lone nodes" (of \emph{any} variable) to prune.
A lone node is a node that has no siblings (an "only child").}

\item{pruneNA}{(Deprecated) Prune all missing values?
This is problematic because "valid" percentages
are hard to interpret when NAs are pruned.}

\item{prunesmaller}{Prune any nodes with count less than specified number.}

\item{labelnode}{List of vectors used to change how values of variables are displayed.
The name of each element of the
list is one of the variable names in \code{vars}.
Each element of the list is a vector of character strings,
representing the values of the variable.
The names of the vector represent the labels to be used in place of the values.}

\item{tlabelnode}{A list of vectors, each of which specifies a particular node,
as well as a label for that node (a "targeted" label).
The names of each vector specify variable names,
except for an element named \code{label}, which specifies the label to use.}

\item{labelvar}{A named vector of labels for variables.}

\item{varminwidth}{A named vector of minimum initial widths for nodes of each variable.
(Sets the Graphviz \code{width} attribute.)}

\item{varminheight}{A named vector of minimum initial heights for nodes of each variable.
(Sets the Graphviz \code{height} attribute.)}

\item{varlabelloc}{A named vector of vertical label locations
("t", "c", or "b" for top, center, or bottom, respectively)
for nodes of each variable.
(Sets the Graphviz \code{labelloc} attribute.)}

\item{fillcolor}{A named vector of colors for filling the nodes of each variable.
If an unnamed, scalar color is specified,
all nodes will have this color.}

\item{fillnodes}{Fill the nodes with color?}

\item{NAfillcolor}{Fill-color for missing-value nodes.
If \code{NULL}, fill colors of missing value nodes will be consistent
with the fill colors in the rest of the tree.}

\item{rootfillcolor}{Fill-color for the root node.}

\item{palette}{A vector of palette numbers (which can range between 1 and 9).
The names of the vector indicate the corresponding variable.
See \strong{Palettes} below for more information.}

\item{gradient}{Use gradients of fill color across the values of each variable?
A single value (with no names) specifies the setting for all variables.
A logical vector of \code{TRUE} values for named variables is interpreted as
\code{TRUE} for those variables and \code{FALSE} for all others.
A logical vector of \code{FALSE} values for named variables is interpreted as
\code{FALSE} for those variables and \code{TRUE} for all others.}

\item{revgradient}{Should the gradient be reversed (i.e. dark to light instead of light to dark)?
A single value (with no names) specifies the setting for all variables.
A logical vector of \code{TRUE} values for named variables is interpreted as
A logical vector of \code{FALSE} values for named variables is interpreted as
\code{FALSE} for those variables and \code{TRUE} for all others.}

\item{singlecolor}{When a variable has a single value,
this parameter is used to specify whether nodes should have a
(1) light shade, (2) a medium shade, or (3) a dark shade.
specify \code{singlecolor=1} to assign a light shade.}

\item{colorvarlabels}{Color the variable labels?}

\item{title}{Optional title for the root node of the tree.}

\item{sameline}{Display node labels on the same line as the count and percentage?}

\item{Venn}{Display multi-way set membership information?
This provides an alternative to a Venn diagram.
This sets \code{showpct=FALSE} and \code{shownodelabels=FALSE}.
Assumption: all of the specified variables are logicals or 0/1 numeric variables.}

\item{check.is.na}{Replace each variable named in \code{vars} with a logical vector indicating
whether or not each of its values is missing?}

\item{seq}{Display the variable tree using "sequences"?
Each unique sequence (i.e. pattern) of values will be shown separately.
The sequences are sorted from least frequent to most frequent.}

\item{pattern}{Same as \code{seq}, but lines without arrows are drawn,
and instead of a \code{sequence} variable, a \code{pattern} variable is shown.}

\item{ptable}{Generate a pattern table instead of a variable tree? 
Only applies when \code{pattern=TRUE}.}

\item{showroot}{Show the root node?
When \code{seq=TRUE}, it may be useful to set \code{showroot=FALSE}.}

\item{text}{A list of vectors containing extra text to add to
nodes corresponding to specified values of a specified variable.
The name of each element of the list
must be one of the variable names in \code{vars}.
Each element is a vector of character strings.
The names of the vector identify the nodes to which the text should be added.
(See \strong{Formatting codes} below for information
on how to format text.)}

\item{ttext}{A list of vectors, each of which specifies a particular node,
as well as text to add to that node ("targeted" text).
The names of each vector specify variable names,
except for an element named \code{text}, which specifies the text to add.}

\item{plain}{Use "plain" settings?
These settings are as follows: for each variable all nodes are the same color,
namely a shade of blue (with each successive variable using a darker shade);
all variable labels are black; and the \code{squeeze} parameter is set to 0.6.}

\item{squeeze}{The degree (between 0 and 1) to which the tree will be "squeezed".
This controls two Graphviz parameters: \code{margin} and \code{nodesep}.}

\item{showvarinnode}{Show the variable name in each node?}

\item{shownodelabels}{Show node labels?
A single value (with no names) specifies the setting for all variables.
A logical vector of \code{TRUE} values for named variables is interpreted as
\code{TRUE} for those variables and \code{FALSE} for all others.
A logical vector of \code{FALSE} values for named variables is interpreted as
\code{FALSE} for those variables and \code{TRUE} for all others.}

\item{showvarnames}{Show the name of the variable next to each level of the tree?}

\item{showlevels}{(Deprecated) Same as showvarnames.}

\item{showpct}{Show percentage in each node?
A single value (with no names) specifies the setting for all variables.
A logical vector of \code{TRUE} for named variables is interpreted as
A logical vector of \code{FALSE} for named variables is interpreted as
\code{FALSE} for those variables and TRUE for all others.}

\item{showlpct}{Show percentages (for the marginal frequencies) in the legend?}

\item{showcount}{Show count in each node?
A single value (with no names) specifies the setting for all variables.
A logical vector of \code{TRUE} for named variables is interpreted as
A logical vector of \code{FALSE} for named variables is interpreted as
\code{FALSE} for those variables and \code{TRUE} for all others.}

\item{showlegend}{Show legend (including marginal frequencies) for each variable?}

\item{varnamepointsize}{Font size (in points) to use when displaying variable names.}

\item{HTMLtext}{Is the text formatted in HTML?}

\item{digits}{Number of decimal digits to show in percentages.}

\item{cdigits}{Number of decimal digits to show in continuous values displayed via the summary parameter.}

\item{splitwidth}{The minimum number of characters before an automatic
linebreak is inserted.}

\item{lsplitwidth}{In legends, the minimum number of characters before an automatic
linebreak is inserted.}

\item{getscript}{Instead of displaying the variable tree,
return the DOT script as a character string?}

\item{nodesep}{Graphviz attribute: Node separation amount.}

\item{ranksep}{Graphviz attribute: Rank separation amount.}

\item{margin}{Graphviz attribute: node margin.}

\item{vp}{Use "valid percentages"?
Valid percentages are computed by first excluding any missing values,
i.e. restricting attention to the set of "valid" observations.
The denominator is thus the number of non-missing observations.
When \code{vp=TRUE}, nodes for missing values show the number of missing values
but do not show a percentage;
all the other nodes how valid percentages.
When \code{vp=FALSE}, all nodes (including nodes for missing values)
show percentages of the total number of observations.}

\item{horiz}{Should the tree be drawn horizontally?
(i.e. parent node on the left, with the tree growing to the right)}

\item{summary}{A character string used to specify summary statistics to display in the nodes.
The first word in the character string is the name of the variable to be summarized.
The rest of the character string is the text that will be displayed,
along with special codes specifying the information to display
(see \strong{Summary codes} below).
A vector of character strings can also be specified,
if more than one variable is to be summarized.}

\item{runsummary}{A list of functions, with the same length as \code{summary}.
Each function must take a data frame as its sole argument,
and return a logical value.
Each string in \code{summary} will only be interpreted if
the corresponding logical value is \code{TRUE}.
the corresponding string in \code{summary} will be evaluated.}

\item{retain}{Vector of names of additional variables in the data frame that need to be
available to execute the functions in \code{runsummary}.}

\item{width}{Width (in pixels) to be passed to \code{DiagrammeR::grViz}.}

\item{height}{Height (in pixels) to be passed to \code{DiagrammeR::grViz}.}

\item{graphattr}{Character string: Additional attributes for the Graphviz graph.}

\item{nodeattr}{Character string: Additional attributes for Graphviz nodes.}

\item{edgeattr}{Character string: Additional attributes for Graphviz edges.}

\item{color}{A vector of color names for the \emph{outline} of the nodes at each level.}

\item{colornodes}{Color the node outlines?}

\item{mincount}{Minimum count to include in a pattern tree or pattern table.}

\item{maxcount}{Maximum count to include in a pattern tree or pattern table.
(Overrides mincount.)}

\item{showempty}{Show nodes that do not contain any observations?}

\item{rounded}{Use rounded boxes for nodes?}

\item{nodefunc}{A node function (see \strong{Node functions} below).}

\item{nodeargs}{A list containing named arguments for the node function
specified by \code{nodefunc}.}

\item{choicechecklist}{When REDCap checklists are specified using the \code{stem:} syntax,
automatically extract the names of choices and use them as variable names?}

\item{arrowhead}{DOT arrowhead style. Defaults to \code{"normal"}.
Other choices include \code{"none"}, \code{"vee"}.}

\item{pxwidth}{Width in pixels of the PNG bitmap to be rendered
when \code{vtree} is called from R Markdown.
If neither \code{pxwidth} nor \code{pxheight} is specified,
\code{pxwidth} is automatically set to 2000 pixels.}

\item{pxheight}{Height in pixels of the PNG bitmap to be rendered
when \code{vtree} is called from R Markdown.}

\item{imagewidth}{A character string specifying the width of the PNG image
to be rendered when \code{vtree} is called from R Markdown,
e.g. \code{"4in"}}

\item{imageheight}{A character string specifying the height of the PNG image
to be rendered when \code{vtree} is called from R Markdown,
e.g. \code{"5in"}.
If neither \code{imageheight} nor \code{imagewidth} is specified,
\code{imageheight} is set to 3 inches.}

\item{folder}{Optional path to a folder where the PNG file should stored
when called during knit}

\item{pngknit}{Generate a PNG file when called during knit?}

\item{as.if.knit}{Behave as if called while knitting?}

\item{maxNodes}{An error occurs if the number of nodes exceeds \code{maxNodes},
which defaults to 1000.}

\item{parent}{Parent node number (Internal use only.)}

\item{last}{Last node number (Internal use only.)}

\item{root}{Is this the root node of the tree? (Internal use only.)}
}
\value{
The value returned by \code{vtree} varies
depending on both the parameter values specified
and the context in which \code{vtree} is called.

First, there are two special cases where \code{vtree} does not show a variable tree:
 
\itemize{
  \item If \code{ptable=TRUE}, the return value is a data frame representing a pattern table.
  \item Otherwise, if \code{getscript=TRUE}, the return value is a character string,
        consisting of a DOT script that describes the variable tree.
}

If neither of the above cases applies, the return value is as follows.
If knitting is \emph{not} taking place
(such as when \code{vtree} is used \strong{interactively}):
\itemize{
  \item the return value is an object of class \code{htmlwidget} (see \link[DiagrammeR]{DiagrammeR}).
        It will intelligently print itself into HTML in a variety of contexts
        including the R console, within R Markdown documents,
        and within Shiny output bindings.
}

If knitting \emph{is} taking place:
\itemize{
  \item If \code{pngknit=TRUE} (the default),
        the return value is a character string of
        pandoc markdown code to embed a PNG file with fully-specified path.
        The character string will have class \code{knit_asis} so that
        knitr will treat it as is
        (the effect is the same as the chunk option results = 'asis')
        when it is written to the output. (See \code{?knitr::asis_output})
  \item If \code{pngknit=FALSE}, the return value is the same as when knitting is not
        taking place, i.e. an object of class \code{htmlwidget}.
}
}
\description{
\code{vtree} is a tool for drawing variable trees.
Variable trees display information about nested subsets of a data frame,
in which the subsetting is defined by the values of categorical variables.
}
\section{R Markdown}{

As noted in the \strong{Value} section above,
\code{vtree} has special support for R Markdown.

By default, when knitting an R Markdown file,
\code{vtree} generates PNG files and embeds them automatically in the output document.
This feature is needed when knitting to a \code{.docx} file.
When knitting to HTML, it is not necessary to generate PNG files
because HTML browsers can directly display htmlwidgets.

To generate htmlwidgets instead of PNG files, specify \code{pngknit=FALSE}.
(Note, however, that there are some advantages to embedding PNG files in an HTML file.
For example,
some browsers perform poorly when numerous htmlwidgets are included in an HTML file.)

When PNG files are generated, they are stored by default in a temporary folder.
The folder can also be specified using the \code{folder} parameter.
(Using the base R function \code{options}, 
a custom option \code{vtree_folder} is used to automatically keep track of this.)
Successive PNG files generated by an R Markdown file
are named \code{vtree1.png}, \code{vtree2.png}, etc.
(A custom option \code{vtree_count} is used to automatically keep track of the number of PNG files.)
}

\section{Summary codes}{

\itemize{
 \item{\code{\%mean\%} }{mean}
 \item{\code{\%SD\%} }{standard deviation}
 \item{\code{\%sum\%} }{sum}
 \item{\code{\%min\%} }{minimum}
 \item{\code{\%max\%} }{maximum}
 \item{\code{\%pX\%} }{Xth percentile, e.g. p50 means the 50th percentile}
 \item{\code{\%median\%} }{median, i.e. p50}
 \item{\code{\%IQR\%} }{interquartile range, i.e. p25, p75}
 \item{\code{\%npct\%} }{number and percentage of \code{TRUE} values}
 \item{\code{\%list\%} }{list of the individual values}
 \item{\code{\%mv\%} }{the number of missing values}
 \item{\code{\%nonmv\%} }{the number of non-missing values}
 \item{\code{\%v\%} }{the name of the variable}
 \item{\code{\%noroot\%} }{flag: Do not show summary in the root node.}
 \item{\code{\%leafonly\%} }{flag: Only show summary in leaf nodes.}
 \item{\code{\%var=}V\code{\%} }{flag: Only show summary in nodes of variable V.}
 \item{\code{\%node=}N\code{\%} }{flag: Only show summary in nodes with value N.}
 \item{\code{\%trunc=}n\code{\%} }{flag: Truncate the summary to the first n characters.}
}
}

\section{Formatting codes}{

Formatting codes for the \code{text} argument.
Also used by \code{labelnode} and \code{labelvar}.
\itemize{
 \item{\code{\\n} }{line break}
 \item{\code{*...*} }{italics}
 \item{\code{**...**} }{bold}
 \item{\code{^...^} }{superscript (using 10 point font)}
 \item{\code{~...~} }{subscript (using 10 point font)}
 \item{\code{\%\%red ...\%\%} }{display text in red (or whichever color is specified)}
}
}

\section{Palettes}{

Sequential palettes from Color Brewer:
\enumerate{
 \item{Reds}
 \item{Blues}
 \item{Greens}
 \item{Oranges}
 \item{Purples}
 \item{YlGn}
 \item{PuBu}
 \item{PuRd}
 \item{YlOrBr}
}
}

\examples{

# Call to vtree 
vtree(FakeData,"Sex Severity")

# R Markdown inline call to vtree
# `r vtree(FakeData,"Sex Severity")`

# A single-level hierarchy
vtree(FakeData,"Severity")

# A two-level hierarchy
vtree(FakeData,"Severity Sex")

# Rename some nodes
vtree(FakeData,"Severity Sex",labelnode=list(Sex=(c("Male"="M","Female"="F"))))

# Rename a variable
vtree(FakeData,"Severity Sex",labelvar=c(Severity="How bad?"))

# Show legend. Put labels on the same line as counts and percentages
vtree(FakeData,"Severity Sex Viral",sameline=TRUE,showlegend=TRUE)

# Using the summary parameter to list ID numbers (truncated to 40 characters) in specified nodes
vtree(FakeData,"Severity Sex",summary="id \nid = \%list\% \%var=Severity\% \%trunc=40\%")

# Adding text to specified nodes of a tree ("targeted text")
vtree(FakeData,"Severity Sex",ttext=list(
  c(Severity="Severe",Sex="M",text="\nMales with Severe disease"),
  c(Severity="NA",text="\nUnknown severity")))

}
\author{
Nick Barrowman <nbarrowman@cheo.on.ca>
}
