% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regex_year_date.R
\name{regex_year_date}
\alias{regex_year_date}
\title{Generate regular expression of a year date.}
\usage{
regex_year_date(format = "yyyy")
}
\arguments{
\item{format}{The format of the year date. Possible values are:
\itemize{
\item{"yyyy"}: to generate "2023".
\item{"yyyy-MM-dd"}: to generate "2023-09-29".
\item{"yyyy/MM/dd"}: to generate "2023/09/29".
\item{"yyyy.MM.dd"}: to generate "2023.09.29".
\item{"yyyy-M-d"}: to generate "2023-9-29".
\item{"yyyy/M/d"}: to generate "2023/9/29".
\item{"yyyy.M.d"}: to generate "2023.9.29".
\item{"yyyy-MM-dd HH:mm:ss"}: to generate "2023-09-29 12:34:56".
\item{"yyyy/MM/dd HH:mm:ss"}: to generate "2023/09/29 12:34:56".
\item{"yyyy-MM-dd HH:mm"}: to generate "2023-09-29 12:34".
\item{"yyyy/MM/dd HH:mm"}: to generate "2023/09/29 12:34".
}}
}
\value{
A regular expression.
}
\description{
This function generates a regular expression for year date based on the input format.
}
\examples{
regex_year_date("yyyy")
regex_year_date("yyyy-MM-dd")
regex_year_date("yyyy/MM/dd")
regex_year_date("yyyy.MM.dd")
regex_year_date("yyyy-M-d")
regex_year_date("yyyy/M/d")
regex_year_date("yyyy.M.d")
regex_year_date("yyyy-MM-dd HH:mm:ss")
regex_year_date("yyyy/MM/dd HH:mm:ss")
regex_year_date("yyyy-MM-dd HH:mm")
regex_year_date("yyyy/MM/dd HH:mm")

}
