% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/colors.R
\name{wa_pal}
\alias{wa_pal}
\title{Washington State Color Palette Generator}
\usage{
wa_pal(
  palette,
  n,
  which = NULL,
  type = c("discrete", "continuous"),
  reverse = FALSE
)
}
\arguments{
\item{palette}{The name of the palette (partial matching supported), or an
actual palette from \verb{[wacolors]}.}

\item{n}{The number of colors in the palette. If this exceeds the actual
number and \code{type} is not provided, it will be set to \code{continuous}.}

\item{which}{if not \code{NULL}, the indices or names of a subset of colors to use.}

\item{type}{Either \code{continuous} or \code{discrete}. Use \code{continuous} if you want
to automatically interpolate between colors.}

\item{reverse}{\code{TRUE} if palette should be reversed.}
}
\value{
A vector of colors of type \code{palette}. If printed to the console, will
plot the palette as well.
}
\description{
Generate \code{palette} objects from the \code{wacolors} list
}
\examples{
wa_pal("rainier")
wa_pal(wacolors$rainier)
wa_pal("sound_sunset", 20, "continuous")
wa_pal("washington_pass", reverse=TRUE)

}
