% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/id.R
\name{id}
\alias{id}
\alias{id_factor}
\title{Identification Numbers}
\usage{
id(n, random = FALSE, name = "ID")

id_factor(n, random = FALSE, name = "ID")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{random}{logical.  If \code{TRUE} the IDs are randomized, otherwise the
IDs are sequential.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a (optionally random) vector of
\code{\link[base]{character}}/\code{\link[base]{factor}} observations
ID numbers.
}
\description{
\code{id} - Generate a sequential \code{\link[base]{character}} vector of
zero-padded identification numbers (IDs).

\code{id_factor} - Generate a sequential \code{\link[base]{factor}} vector
of zero-padded identification numbers (IDs).
}
\note{
\code{id} is faster than \code{id_factor}, as the later coerces the
vector to a \code{\link[base]{factor}}.
}
\section{Warning}{
 \code{id} uses \code{\link[base]{sprintf}} to generate the
padded ID.  Per \code{\link[base]{sprintf}}'s documentation: ``The format
string is passed down the OS's sprintf function...The behaviour on inputs not
documented here is 'undefined', which means it is allowed to differ by
platform.''  See \code{\link[base]{sprintf}} for details.
}
\examples{
id(1000)
r_data_frame(n=21, id)
}
\seealso{
\code{\link[base]{sprintf}}
}
\keyword{id}
\keyword{identification}

