% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/internet_browser.R
\name{internet_browser}
\alias{internet_browser}
\title{Generate Random Vector of Internet Browsers}
\usage{
internet_browser(n, x = c("Chrome", "IE", "Firefox", "Safari", "Opera",
  "Android"), prob = c(0.5027, 0.175, 0.1689, 0.0994, 0.017, 0.0132),
  name = "Browser")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random factor vector of Internet browser elements.
}
\description{
Generate a random vector of Internet browser.
}
\details{
The browser use and probabilities (from \url{http://gs.statcounter.com}):

\tabular{lr}{
  \bold{ Browser} \tab \bold{Percent} \cr
  Chrome  \tab 50.27 \%\cr
  IE      \tab 17.50 \% \cr
  Firefox \tab 16.89 \%\cr
  Safari  \tab 9.94 \% \cr
  Opera   \tab 1.70 \%  \cr
  Android \tab 1.32 \% \cr
}
}
\examples{
internet_browser(20)
barplot(table(internet_browser(10000)))
pie(table(internet_browser(10000)))
}
\references{
\url{http://www.pewforum.org/2012/12/18/table-religious-composition-by-country-in-numbers}
}
\seealso{
Other variable.functions: \code{\link{age}};
  \code{\link{animal}}, \code{\link{pet}};
  \code{\link{answer}}; \code{\link{area}};
  \code{\link{birth}}, \code{\link{dob}};
  \code{\link{car}}; \code{\link{children}};
  \code{\link{coin}}; \code{\link{color}},
  \code{\link{primary}}; \code{\link{date_stamp}};
  \code{\link{death}}, \code{\link{died}};
  \code{\link{dice}}; \code{\link{dna}};
  \code{\link{dummy}}; \code{\link{education}};
  \code{\link{ela}}, \code{\link{level}},
  \code{\link{math}}; \code{\link{employment}};
  \code{\link{eye}}; \code{\link{gender_inclusive}},
  \code{\link{sex_inclusive}}; \code{\link{gender}},
  \code{\link{sex}}; \code{\link{gpa}},
  \code{\link{grade}}, \code{\link{grade_letter}};
  \code{\link{grade_level}}; \code{\link{group}};
  \code{\link{hair}}; \code{\link{height}},
  \code{\link{height_cm}}, \code{\link{height_in}};
  \code{\link{income}}; \code{\link{iq}};
  \code{\link{language}}; \code{\link{likert}},
  \code{\link{likert_5}}, \code{\link{likert_7}};
  \code{\link{lorem_ipsum}}, \code{\link{paragraph}};
  \code{\link{lower}}, \code{\link{lower_factor}},
  \code{\link{upper}}, \code{\link{upper_factor}};
  \code{\link{marital}}; \code{\link{military}};
  \code{\link{month}}; \code{\link{name}};
  \code{\link{normal}}, \code{\link{normal_round}};
  \code{\link{political}}; \code{\link{race}};
  \code{\link{religion}}; \code{\link{sat}};
  \code{\link{sentence}}; \code{\link{smokes}};
  \code{\link{speed}}, \code{\link{speed_kph}},
  \code{\link{speed_mph}}; \code{\link{state}};
  \code{\link{string}}; \code{\link{valid}};
  \code{\link{year}}; \code{\link{zip_code}}
}
\keyword{browser}

