% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_data.R
\name{r_data}
\alias{r_data}
\alias{r_data_theme}
\title{Pre-Selected Column Data Set}
\usage{
r_data(n = 500, ...)

r_data_theme(n = 100, data_theme = "the_works")
}
\arguments{
\item{n}{The length to pass to the randomly generated vectors (number of rows).}

\item{data_theme}{A data theme.  Currently selections include:
\describe{
  \item{the_works}{all available variable functions}
  \item{survey}{ID column plus 10 numeric 5-point Likert type response columns}
  \item{survey2}{ID column plus 10 5-point Likert type response columns}
}}

\item{\ldots}{A set of optionally named arguments.  Using \pkg{wakefield}
variable functions require no name or call parenthesis.}
}
\value{
Returns a \code{\link[dplyr]{tbl_df}}.
}
\description{
\code{r_data} - Generate a data set with pre-set columns selected.

\code{r_data_theme} - Generate a themed data set with pre-set columns.
}
\details{
The pre-selected columns include:

\itemize{
  \item ID
  \item Race
  \item Age
  \item Sex
  \item Hour
  \item IQ
  \item Height
  \item Died
}

The user may use \ldots to add additional columns.  \code{r_data} is a
convenience function to quickly produce a data set.  For more specific usage
use the more flexible \code{\link[wakefield]{r_data_frame}} function.
}
\examples{
r_data()
r_data(10)
r_data(10, paragraph, Attending = valid)

peek(r_data_theme())
plot(r_data_theme(), flip=TRUE)

r_data_theme(, "survey")
r_data_theme(, "survey2")
}
\seealso{
\code{\link[wakefield]{r_data_frame}}
}
