#' @name wallace-package
#' @aliases wallace
#' @aliases wallace-package
#' @docType package
#' @title \emph{Wallace}: A modular platform for reproducible ecological modeling
#' @description \emph{Wallace} is a \code{shiny} app that guides users through a complete
#'   species niche/distributional modeling analysis, from the acquisition of
#'   species occurrence and environmental data to visualizing model predictions
#'   on an interactive map (\code{rleaflet}), thus bundling complex workflows
#'   into a single, streamlined GUI interface. New functionality, in the form of
#'    modules, can be added to \emph{Wallace} via contributions from the user
#'    community. In addition, executable session code (R Markdown format) can
#'    be downloaded to share with others or use as supplementary information
#'    for scientific papers and reports. The application is run via the
#'    function \code{\link{run_wallace}}.
#'
#' @details Please see the official website (\url{https://wallaceecomod.github.io/}) for
#'   more details. If you have questions about the application, please participate
#'   in the \href{https://groups.google.com/forum/#!forum/wallaceecomod}{Google Group},
#'   or email the team directly: \email{wallaceEcoMod@@gmail.com}.
#'
#' @import leaflet shiny
#' @importFrom magrittr "%>%"
NULL
