% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/manualoc_1.9.R
\name{manualoc}
\alias{manualoc}
\title{Interactive view of spectrograms}
\usage{
manualoc(wl = 512, flim = c(0,12), seltime = 1, tdisp = NULL, reccomm =
  FALSE, wn = "hanning", title = TRUE, selcomm = FALSE, osci = FALSE, player =
  NULL, pal = reverse.gray.colors.2)
}
\arguments{
\item{wl}{a number specifying the spectrogram window length, default is 512.}

\item{flim}{a numeric vector of length two for the frequency limit in kHz of
the spectrogram, as in the function spectro() in the seewave package.
Default is c(0,12).}

\item{seltime}{time interval in seconds at which the spectrograms are produce
with higher "resolution" (ovlp = 70) and oscilograms (if "osci=TRUE").
Default is 1 s.}

\item{tdisp}{length in seconds of the total sound file to be displayed.
Default is NULL which displays the full sound file.}

\item{reccomm}{if TRUE pops up a comment window at the end of each sound file.
The comment needs to be quoted. Default is FALSE.}

\item{wn}{window function (by default "hanning"). See function ftwindow() in
seewave package.}

\item{title}{if TRUE the name of the sound file will be printed as the main
title of the spectrogram window. Default is TRUE.}

\item{selcomm}{if TRUE pops up a comment window after each selection. The
comment is printed as a label on the selected unit. The comment needs to be
quoted. Default is FALSE.}

\item{osci}{if TRUE adds a oscillogram whenever the spectrograms are produce
with higher "resolution" (see seltime). Default is FALSE.}

\item{player}{path to or name of a program capable of playing a wave file by
invocation from the command line. If under Windows and no player is given,
windows player will be chosen as the default. The external program must be
closed before resuming analysis. Default is NULL.}

\item{pal}{a color palette function to be used to assign colors in the
plot, as in \code{\link[seewave]{spectro}} (seewave package). Default is
reverse.gray.colors.2. See Details.}
}
\value{
.csv file saved in the working directory with start and end of
  selections.
}
\description{
\code{manualoc} produce an interactive spectrographic view to measure start
and end times of acoustic signals.
}
\details{
Users can zoom-in a specific sound file segment by clicking at the
  start and end (left side and right side) of the segment. To select the
  start and end of a vocalization unit the users need to click at the end and
  then at the start (right side and left side) of the unit. In addition, 6
  "buttons" are provided at the upper right side of the spectrogram that
  allow to display a full view of the spectrogram ("Full view"), go back to
  the previous view ("Previous view"), stop the analysis ("Stop"), go to the
  next sound file ("Next rec"), play the current view using external software
  ("Play", see "player" argument), or delete the last manual selection in the
  current sound file ("Del-sel"). When a unit has been selected the function
  plots a red circle with the selection number in the middle point of the
  selection in the spectrogram. It also plots vertical dotted lines at the
  start and end of the selection. The circle and lines "disappear" when the
  selection is deleted ("Del-sel" button).

  The function produces and .csv file (manualoc_output.csv) with information about the .wav file name,
  selection number, start and end time, selection comment (selcomm), and
  sound file comment (reccomm). The file is saved in the working directory and
  is updated every time the user moves into the next sound file (Next rec
  "button") or stop the process (Stop "button"). When resuming the process
  (after "stop" and re-running the function in the same working directory),
  the function will keep the previous selections and will only pick up .wav
  files that are not present in the .csv file (not previously analyzed).

  When users go to the next sound file (Next rec "button") without making any
  selection the file is still included in the .csv file, with NA's in the
  "end", "time" and "selec" field. Windows length (wl) control the temporal
  and frequency precision of the spectrogram. A high "wl" value increases the
  frequency resolution but reduces the temporal one, and vice versa. Any
  color palette that comes with the seewave package can be used: temp.colors,
  reverse.gray.colors.1, reverse.gray.colors.2, reverse.heat.colors, reverse.terrain.colors,
  reverse.topo.colors, reverse.cm.colors, heat.colors, terrain.colors, topo.colors,
  cm.colors. The function could be slow when working on files of length > 5min.
}
\examples{
\dontrun{
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav")
manualoc()
}
}
\author{
Marcelo Araya-Salas http://marceloarayasalas.weebly.com/
}

