% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/song_param.R
\name{song_param}
\alias{song_param}
\title{Measure acoustic parameters at the song level}
\usage{
song_param(X = NULL, weight = NULL, song_colm = "song",
mean_indx = NULL, min_indx = NULL, max_indx = NULL, sd = FALSE, 
parallel = 1, pb = TRUE, na.rm = FALSE)
}
\arguments{
\item{X}{'selection_table', 'extended_selection_table' (created 'by.song') or data frame with the following columns: 1) "sound.files": name of the .wav 
files, 2) "selec": number of the selections, 3) "start": start time of selections, 4) "end": 
end time of selections. The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can 
be used as the input data frame. Other data frames can be used as input, but must have at least the 4 columns mentioned above.}

\item{weight}{Character vector defining 1 or more numeric vectors to weight average
measurements (i.e. song parameters). Default is \code{NULL}. Names of numeric columns in 'X' can also be used. See \code{\link[stats]{weighted.mean}}. 
 for more details. To use unweighted average set 'weight' to \code{NULL}.}

\item{song_colm}{Character string with the column name containing song labels. Note that 
the function assumes that song labels are not repeated within a sound file.}

\item{mean_indx}{Numeric vector with the index of the columns that will be averaged. If \code{NULL} the mean of all numeric columns in 'X' is returned.}

\item{min_indx}{Numeric vector with the index of the columns for which the minimum 
value is needed. Default is \code{NULL}.}

\item{max_indx}{Numeric vector with the index of the columns for which the maximum 
value is needed. Default is \code{NULL}.
If  \code{NULL} the mean of all numeric columns in 'X' is returned.}

\item{sd}{Logical value indicating whether standard deviaton is also returned for
variables in which averages are reported. Default is \code{FALSE}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar and messages. Default is \code{TRUE}.}

\item{na.rm}{Logical value indicating whether 'NA' values should be ignored for calculations.}
}
\value{
A data frame similar to the input 'X' data frame, containing the mean
 values for numeric acoustic parameters. Parameters to average can be defined with
 'mean_indx' (otherwhise all numeric parameters are used). Parameters can be 
 weighted by other parameters in the data set (e.g. duration, frequency range). Note
 that the functions works by default on songs, but can be used at other hierarchical
 levels (e.g. syllables, singing bouts). This function assumes that song labels are
  not repeated within a sound file.
}
\description{
\code{song_param} measures average or extreme values of acoustic parameters of 
elements in a song
}
\details{
The function removes silence segments (i.e. segments with very low amplitude values) from wave files.
}
\examples{
{
# Set temporary working directory

# get warbleR sound file examples
data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec.table"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav") 

# add a 'song' column
selec.table$song <- rep(1:4, each = 3)[1:11]

# measure acoustic parameters
sp <- specan(selec.table, bp = c(1, 11), 300, fast = TRUE)

# add song data
sp <- merge(sp, selec.table, by = c("sound.files", "selec"))

# caculate song-level parameters for all numeric parameters
song_param(X = sp, song_colm = "song", parallel = 1, pb = TRUE)

# caculate song-level parameters selecting parameters with mean_indx
song_param(X = sp, song_colm = "song",mean_indx = 5:10, parallel = 1, pb = TRUE)

# caculate song-level parameters for selecting parameters with mean_indx, max_indx
# and min_indx and weighted by duration
song_param(X = sp, weight = "duration", song_colm = "song",
mean_indx = 5:6, min_indx = 7:8, max_indx = 9:10, parallel = 1, pb = TRUE)

# with two weights 
song_param(X = sp, weight = c("duration", "dfrange"), song_colm = "song",
mean_indx = 5:9, parallel = 1, pb = TRUE)

# with two weights no progress bar
song_param(X = sp, weight = c("duration", "dfrange"), song_colm = "song",
mean_indx = 5:9, parallel = 1, pb = FALSE)
}

}
\seealso{
\code{\link{fixwavs}}, \code{\link{autodetec}},
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu})
}
