% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sound_pressure_level.R
\encoding{UTF-8}
\name{sound_pressure_level}
\alias{sound_pressure_level}
\title{Measure sound pressure level}
\usage{
sound_pressure_level(X, reference = 20, parallel = 1, path = NULL, pb = TRUE, 
peak.amplitude = FALSE, wl = 100)
}
\arguments{
\item{X}{object of class 'selection_table', 'extended_selection_table' or any data frame with columns
for sound file name (sound.files), selection number (selec), and start and end time of signal
(start and end).}

\item{reference}{Numeric vector of length 1 indicating the pressure (in µPa) to be used as reference. Alternatively, a character vector with the name of a numeric column containing reference values for each row can be supplied. Default is 20 (µPa).}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing). It can also be
set globally using the 'parallel' option (see \code{\link{warbleR_options}}).}

\item{path}{Character string containing the directory path where the sound files are located.
If \code{NULL} (default) then the current working directory is used. It can also be
set globally using the 'wav.path' option (see \code{\link{warbleR_options}}).}

\item{pb}{Logical argument to control if progress bar is shown. Default is \code{TRUE}. It can also be
set globally using the 'pb' option (see \code{\link{warbleR_options}}).}

\item{peak.amplitude}{Logical argument controlling if the sound pressure level across the entire signal is return or only that of the highest amplitude (i.e. peak amplitude) of the signal. Default is \code{FALSE}.}

\item{wl}{A numeric vector of length 1 specifying the spectrogram window length. Default is 512.}
}
\value{
The object supplied in 'X' with a new variable 
with the sound pressure level values ('SPL' or 'peak.amplitude' column, see argument 'peak.amplitude') in decibels.
}
\description{
\code{sound_pressure_level} measures sound pressure level in signals reference in a selection table.
}
\details{
Sound pressure level (SPL) is a logarithmic measure of the effective pressure of a sound relative to a reference, so it's a measure of sound intensity. Note that calibrated measures can be obtained only when the SPL of the environment where recordings were made is used as reference.
  \code{\link{sig2noise}}.
}
\examples{
{
data(list = c("Phae.long1","lbh_selec_table"))
writeWave(Phae.long1, file.path(tempdir(), "Phae.long1.wav")) #save sound files 

spl <- sound_pressure_level(X = lbh_selec_table[grep("Phae.long1", lbh_selec_table$sound.files), ], 
parallel = 1, pb = TRUE, path = tempdir())
}

}
\references{
{Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
\href{https://en.wikipedia.org/wiki/Sound_pressure}{Wikipedia: Sound pressure level}
}
}
\author{
Marcelo Araya-Salas (\email{marcelo.araya@ucr.ac.cr}) and Grace Smith Vidaurre
}
