% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getStatusChanges.R
\name{getStatusChanges}
\alias{getStatusChanges}
\title{Track historical progess on a bill}
\usage{
getStatusChanges(
  biennium,
  billNumber,
  paired = TRUE,
  type = c("df", "list", "xml")
)
}
\arguments{
\item{biennium}{Character vector representing the biennium(s) to be
searched. Each argument should take the form "XXXX-YY"}

\item{billNumber}{Character or numeric vector containing the bill number(s)
to be retrieved.}

\item{paired}{If TRUE, will assume that equal length vectors represent
paired data. Set to FALSE to generate an NxN grid of input
arguments. Applies to equal length vector inputs only.}

\item{type}{One of "df", "list", or "xml". Specifies the format for
the output.}
}
\value{
\code{getStatusChanges} returns an object of type equal to the
\code{type} argument (defaults to dataframe)
}
\description{
Get a complete history of all status changes that occurred on a particular
bill
}
\examples{
getStatusChanges("2007-08", "1001", type = "list")
}
