% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated-wbcache.R
\name{wbcache}
\alias{wbcache}
\title{Download an updated list of country, indicator, and source information}
\usage{
wbcache(lang = c("en", "es", "fr", "ar", "zh"))
}
\arguments{
\item{lang}{Language in which to return the results. If \code{lang} is unspecified,
english is the default.}
}
\value{
A list containing the following items:
\itemize{
\item \code{countries}: A data frame. The result of calling \code{\link{wbcountries}}
\item \code{indicators}: A data frame.The result of calling \code{\link{wbindicators}}
\item \code{sources}: A data frame.The result of calling \code{\link{wbsources}}
\item \code{datacatalog}: A data frame.The result of calling \code{\link{wbdatacatalog}}
\item \code{topics}: A data frame.The result of calling \code{\link{wbtopics}}
\item \code{income}: A data frame.The result of calling \code{\link{wbincome}}
\item \code{lending}: A data frame.The result of calling \code{\link{wblending}}
}
}
\description{
Download an updated list of information regarding countries, indicators,
sources, data catalog, indicator topics, lending types, and income levels
from the World Bank API
}
\note{
Not all data returns have support for langauges other than english. If the specific return
does not support your requested language by default it will return \code{NA}. For an enumeration of
supported languages by data source please see \code{\link{wbdatacatalog}}.
The options for \code{lang} are:
\itemize{
\item \code{en}: English
\item \code{es}: Spanish
\item \code{fr}: French
\item \code{ar}: Arabic
\item \code{zh}: Mandarin
}
List item \code{datacatalog} will always return in english, as the API does not support any
other langauges for that information.

Saving this return and using it has the \code{cache} parameter in \code{\link{wb}} and \code{\link{wbsearch}}
replaces the default cached version \code{\link{wb_cachelist}} that comes with the package itself
}
