% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phantom.R
\name{phantomjs}
\alias{phantomjs}
\title{Start phantomjs}
\usage{
phantomjs(port = 4567L, version = "2.1.1", check = TRUE,
  loglevel = c("INFO", "ERROR", "WARN", "DEBUG"), verbose = TRUE,
  retcommand = FALSE, ...)
}
\arguments{
\item{port}{Port to run on}

\item{version}{what version of phantomjs to run. Default = "2.2.1"
which runs the most recent stable version. To see other version currently
sourced run binman::list_versions("phantomjs")}

\item{check}{If TRUE check the versions of phantomjs available. If
new versions are available they will be downloaded.}

\item{loglevel}{Set phantomjs log level [values: fatal, error,
warn, info, config, debug, trace]}

\item{verbose}{If TRUE, include status messages (if any)}

\item{retcommand}{If TRUE return only the command that would be passed
to \code{\link{spawn_process}}}

\item{...}{pass additional options to the driver}
}
\value{
Returns a list with named elements process, output, error, stop
    and log. process is the output from calling \code{\link{spawn_process}}
    output, error and stop are functions calling
    \code{\link{process_read}}, \code{\link{process_read}} with "stderr"
    pipe and \code{\link{process_kill}}  respectively  on process.
    log is a function which returns the contents of the log file.
}
\description{
Start phantomjs in webdriver mode
}
\examples{
\dontrun{
pjs <- phantomjs()
pjs$output()
pjs$stop()
}
}
