% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpanet_simple.R
\name{rpanet_simple}
\alias{rpanet_simple}
\title{Generate a PA network with linear preference functions.}
\usage{
rpanet_simple(
  nstep,
  initial.network,
  control,
  directed,
  m,
  sum_m,
  w,
  ex_node,
  ex_edge,
  method
)
}
\arguments{
\item{nstep}{Number of steps when generating a network.}

\item{initial.network}{A list represents the seed network. If \code{NULL},
\code{initial.network} will have one edge from node 1 to node 2 with weight 1.
It consists of the following components: a two column matrix
\code{edgelist} represents the edges; a vector \code{edgeweight} represents
the weight of edges; a integer vector \code{nodegroup} represents the group
of each node. \code{nodegroup} is defined for directed networks, if
\code{NULL}, all nodes from the seed graph are considered from group 1.}

\item{control}{A list of parameters to be used when generate network.}

\item{directed}{Logical, whether to generate directed networks. When FALSE,
the edge directions are omitted.}

\item{m}{Integer vector, number of new edges in each step.}

\item{sum_m}{Integer, summation of \code{m}.}

\item{w}{Vector, weight of new edges.}

\item{ex_node}{Integer, number of nodes in \code{initial.network}.}

\item{ex_edge}{Integer, number of edges in \code{initial.network}.}

\item{method}{Which method to use, \code{bag} or \code{bagx}.}
}
\value{
A list with the following components: \code{edgelist};
  \code{edgeweight}; number of new edges in each step \code{newedge}
  (reciprocal edges are not included); \code{node.attribute}, including node
  strengths, preference scores and node group (if applicable); control list
  \code{control}; edge scenario \code{scenario} (1~alpha, 2~beta, 3~gamma,
  4~xi, 5~rho, 6~reciprocal). The edges from \code{initial.network} are
  denoted as scenario 0.
}
\description{
Source preference function must be out-degree (out-strength) plus a
nonnegative constant; target preference function must be in-degree
(in-strength) plus a nonnegative constant.
}
\keyword{internal}
