% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpa_control.R
\name{rpa_control_edgeweight}
\alias{rpa_control_edgeweight}
\title{Control weight of new edges. Defined for \code{rpanet}.}
\usage{
rpa_control_edgeweight(sampler = NULL)
}
\arguments{
\item{sampler}{A function used for sampling edge weights. If \code{NULL}, all
new edges will default to a weight of 1. If a function is provided, it must
accept a single argument, \code{n}, and return a vector of length \code{n}
that represents the sampled edge weights.}
}
\value{
A list of class \code{rpacontrol} containing the \code{sampler}
  function.
}
\description{
Control weight of new edges. Defined for \code{rpanet}.
}
\examples{
# Sample edge weights from Gamma(5, 0.2).
my_gamma <- function(n) rgamma(n, shape = 5, scale = 0.2)
control <- rpa_control_edgeweight(
  sampler = my_gamma
)

}
