% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wdpa_read.R
\name{wdpa_read}
\alias{wdpa_read}
\title{Read data from the World Database on Protected Areas}
\usage{
wdpa_read(x)
}
\arguments{
\item{x}{\code{character} file name for a zip archive file downloaded from
\url{https://www.protectedplanet.net/en}.}
}
\value{
\code{\link[sf:sf]{sf::sf()}} object.
}
\description{
Read data from the World Database on Protected Areas from a local file.
This function assumes that the data has already been downloaded to
your computer, see the \code{\link[=wdpa_fetch]{wdpa_fetch()}} function for automatically
downloading and importing the data into the current session.
}
\examples{
\dontrun{
# find url for Liechtenstein dataset
download_url <- wdpa_url("LIE", wait = TRUE)

# path to save file zipfile with data
path <- tempfile(pattern = "WDPA_", fileext = ".zip")

# download zipfile
result <- httr::GET(download_url, httr::write_disk(path))

# load data
lie_raw_data <- wdpa_read(path)

# plot data
plot(lie_raw_data)
}
}
\seealso{
\code{\link[=wdpa_fetch]{wdpa_fetch()}}, \code{\link[=wdpa_clean]{wdpa_clean()}},
\url{https://www.protectedplanet.net/en}.
}
