% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrapper_functions.R
\name{checkDataAvailabilityForDateRange}
\alias{checkDataAvailabilityForDateRange}
\title{Quick Check to see if WeatherUnderground has Weather Data for given station
 for a range of dates}
\usage{
checkDataAvailabilityForDateRange(station_id, start_date, end_date,
  station_type = "airportCode")
}
\arguments{
\item{station_id}{is a valid 3-letter airport code or a valid Weather Station ID}

\item{start_date}{is a valid string representing a date in the past (YYYY-MM-DD, all numeric)}

\item{end_date}{is a a valid string representing a date in the past (YYYY-MM-DD, all numeric) and is greater than start_date}

\item{station_type}{is either \code{airportCode} or \code{id}}
}
\value{
1 if the Station did have weather records, 0 if nothing was found
}
\description{
Before we attempt to fetch the data for a big time interval of dates, this 
 function is useful to see if the data even exists.
 @details This functions checks for just the first and the last date in the interval,
   not the days in between
}
\examples{
\dontrun{
data_okay <- checkDataAvailabilityForDateRange("BOS", 
                                               "2011-01-01", 
                                               "2011-03-31")
}
}
