% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/chemid.R
\name{chemid}
\alias{chemid}
\title{Retrieve information from ChemIDPlus \url{http://chem.sis.nlm.nih.gov/chemidplus/name/triclosan}}
\usage{
chemid(query, type = c("rn", "name", "inchikey"), verbose = TRUE)
}
\arguments{
\item{query}{character; query string}

\item{type}{character; type of query string.
'rn' for regeistry number or 'name' for common name or 'inchikey' for inchikey as input.}

\item{verbose}{logical; should a verbose output be printed on the console?}
}
\value{
A list of 8 entries: name (vector), synonyms (vector), cas (vector),
inchi (vector), inchikey (vector), smiles(vector), toxicity (data.frame),
physprop (data.frame).
}
\description{
Retrieve information from ChemIDPlus \url{http://chem.sis.nlm.nih.gov/chemidplus/name/triclosan}
}
\note{
The data of the entry \code{physprop} is identical to the result returned
by \code{\link{physprop}}.
}
\examples{
\dontrun{
# might fail if API is not available
y1 <- chemid('Formaldehyde', type = 'name')
str(y1)
y1$name

y2 <- chemid('50-00-0', type = 'rn')
str(y2)
y2$name

y3 <- chemid('50-00-0', type = 'name')
y3
}
}

