context("pan")
skip_if_not(ping_pan())

test_that("pan_query()", {
  skip_on_cran()

  a <- pan_query(c('Triclosan','Chlorpyrifos', 'xxxx', NA), match = 'best', verbose = FALSE)
  b <- pan_query(c('Triclosan','Chlorpyrifos', 'xxxx', NA), match = 'all', verbose = FALSE)
  c <- pan_query(c('Triclosan','Chlorpyrifos', 'xxxx', NA), match = 'first', verbose = FALSE)

  expect_is(a, 'list')
  expect_is(b, 'list')
  expect_is(c, 'list')
  expect_equal(length(a), 4)
  expect_equal(length(b), 4)
  expect_equal(length(c), 4)
  expect_equal(length(a[[1]]), 75)
  expect_equal(length(b[[2]]), 75)
  expect_equal(length(c[[2]]), 75)
  expect_equal(length(a[[1]]$`CAS Number`), 1)
  expect_equal(length(b[[2]]$`CAS Number`), 9)
  expect_equal(length(c[[2]]$`CAS Number`), 1)
  expect_true(is.na(a[[3]]))
  expect_true(is.na(b[[3]]))
  expect_true(is.na(c[[3]]))
  expect_true(is.na(a[[4]]))
  expect_true(is.na(b[[4]]))
  expect_true(is.na(c[[4]]))
  expect_equal(a[[1]]$`CAS Number`, "3380-34-5")
  expect_equal(a[[2]]$`Chemical name`, "Chlorpyrifos")
})