% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdeveloper.R
\name{paramList}
\alias{paramList}
\title{Parse HTTP parameter strings.}
\usage{
paramList(
  x,
  split = "&",
  custom_decode = list(pattern = c("+"), replacement = c(" "))
)
}
\arguments{
\item{x}{A parameter string, likely accessed from req[["rook.input"]]$read_lines().}

\item{split}{The character to use to split the parameter string into constituent parameters.}

\item{custom_decode}{A named list, must consist of list(pattern = c(...), replacement = c(...)) where pattern contains characters to decode that are not included in utils::URLencode
and replacement contains the character to replace the character passed in the same indexed position in pattern.}
}
\value{
A list, with names being parameter names and values being parameter values.
}
\description{
Parse HTTP parameter strings.
}
\examples{
paramList("?param1=Test&param2=1234&param3=Example")
}
