% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/window.R
\name{Window}
\alias{Window}
\title{A browser window}
\description{
A browser window
}
\section{Usage}{

\preformatted{w <- s$getWindow()
wlist <- s$getAllWindows()

w$close()
w$isActive()
w$switchTo()
w$maximize()
w$getSize()
w$setSize(width, height)
w$getPosition()
w$setPosition(x, y)
}
}

\section{Arguments}{

\describe{
  \item{s}{A \code{\link{Session}} object.}
  \item{w}{A \code{Window} object.}
  \item{wlist}{A list of \code{Window} objects.}
  \item{width}{Integer scalar, requested width of the window.}
  \item{height}{Integer scalar, requested height of the window.}
  \item{x}{Integer scalar, requested horizontal window position.}
  \item{y}{Integer scalar, requested vertical window position.}
}
}

\section{Details}{


The \code{getWindow} method of a \code{\link{Session}} object
returns the current browser window as a \code{Window} object.
The \code{getAllWindows} method returns a list of window objects,
all browser windows.

\code{w$close()} closes the window.

\code{w$isActive()} returns \code{TRUE} if the window is active,
\code{FALSE} otherwise.

\code{w$switchTo} makes the window active.

\code{w$maximize} maximizes the window. Currently it sets it to
a fixed size.

\code{w$getSize} returns the size of the window, in a list with
elementh \code{width} and \code{height}, both integers.

\code{w$setSize} sets the size of the window.

\code{w$getPosition} returns the position of the window on the
screen. Phantom.js being headless, it always returns
\code{list(x = 0, y = 0)}, and it is included to have a complete
impelementation of the WebDriver standard.

\code{w$setPosition(x, y)} sets the position of the window on the
screen. Phantom.js being headless, it has no effect, and it is included
to have a complete implementation of the WebDriver standard.
}

