% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wi_th.R
\name{wi_th}
\alias{wi_th}
\title{Set additional parts of a stubbed request}
\usage{
wi_th(.data, ..., .list = list())
}
\arguments{
\item{.data}{input. Anything that can be coerced to a \code{StubbedRequest} class
object}

\item{...}{Comma separated list of named variables. accepts the following:
\code{query}, \code{body}, \code{headers}, \code{basic_auth}. See Details.}

\item{.list}{named list, has to be one of \code{query}, \code{body},
\code{headers} and/or \code{basic_auth}. An alternative to passing in via \code{...}.
Don't pass the same thing to both, e.g. don't pass 'query' to \code{...}, and
also 'query' to this parameter}
}
\value{
an object of class \code{StubbedRequest}, with print method describing
the stub
}
\description{
Set query params, request body, request headers and/or basic_auth
}
\details{
\code{with} is a function in the \code{base} package, so we went with
\code{wi_th}

Values for query, body, headers, and basic_auth:
\itemize{
\item query: (list) a named list. values are coerced to character
class in the recorded stub. You can pass numeric, integer, etc., but
all will be coerced to character.
\item body: various, including character string, list, raw, numeric,
upload (\code{crul::upload} or \code{httr::upload_file}, they both create the
same object in the end)
\item headers: (list) a named list
\item basic_auth: (character) a length two vector, username and password.
authentication type (basic/digest/ntlm/etc.) is ignored. that is,
mocking authenciation right now does not take into account the
authentication type
}

Note that there is no regex matching on query, body, or headers. They
are tested for matches in the following ways:
\itemize{
\item query: compare stubs and requests with \code{identical()}. this compares
named lists, so both list names and values are compared
\item body: varies depending on the body format (list vs. character, etc.)
\item headers: compare stub and request values with \code{==}. list names are
compared with \code{\%in\%}. \code{basic_auth} is included in headers (with the name
Authorization)
}
}
\note{
see more examples in \code{\link[=stub_request]{stub_request()}}
}
\examples{
# first, make a stub object
req <- stub_request("post", "https://httpbin.org/post")

# add body
# list
wi_th(req, body = list(foo = "bar"))
# string
wi_th(req, body = '{"foo": "bar"}')
# raw
wi_th(req, body = charToRaw('{"foo": "bar"}'))
# numeric
wi_th(req, body = 5)
# an upload
wi_th(req, body = crul::upload(system.file("CITATION")))
# wi_th(req, body = httr::upload_file(system.file("CITATION")))

# add query - has to be a named list
wi_th(req, query = list(foo = "bar"))

# add headers - has to be a named list
wi_th(req, headers = list(foo = "bar"))
wi_th(req, headers = list(`User-Agent` = "webmockr/v1", hello="world"))

# .list - pass in a named list instead
wi_th(req, .list = list(body = list(foo = "bar")))

# basic authentication
wi_th(req, basic_auth = c("user", "pass"))
wi_th(req, basic_auth = c("user", "pass"), headers = list(foo = "bar"))
}
