% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/image.R
\name{shrink}
\alias{shrink}
\title{Shrink file size of a PNG}
\usage{
shrink(filename)
}
\arguments{
\item{filename}{Name of image to shrink. Must be a PNG file.}
}
\description{
This does not change size of the image in pixels, nor does it affect
appearance -- it is lossless compression. This requires the program
\code{optipng} to be installed.
}
\details{
If other operations like resizing are performed, shrinking should occur as
the last step. Otherwise, if the resizing happens after file shrinking, it
will be as if the shrinking didn't happen at all.
}
\examples{
if (interactive()) {
  webshot("http://www.google.com/", "google-shrink.png") \%>\%
    shrink()
}
}

