% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/audience_networks.R
\name{audience_network}
\alias{audience_network}
\title{Create audience networks}
\usage{
audience_network(wt, cutoff = 3, type = "pmi", alpha = 0.05)
}
\arguments{
\item{wt}{webtrack data object}

\item{cutoff}{visits below this cutoff will not be considered as a visit}

\item{type}{one of "pmi", "phi", "disparity", "sdsm, "or "fdsm".}

\item{alpha}{significance level}
}
\value{
audience network as igraph object
}
\description{
audience network
}
\examples{
data("test_data")
wt <- as.wt_dt(test_data)
wt <- add_duration(wt)
wt <- extract_domain(wt)
audience_network(wt, type = "pmi", cutoff = 120)
}
