% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{atkinson_index}
\alias{atkinson_index}
\title{Symmetric Atkinson Index
calculates the symmetric Atkinson index}
\usage{
atkinson_index(grp_a, grp_b)
}
\arguments{
\item{grp_a}{vector (usually corresponds to a column in a webtrack
data frame) indicating the number of individuals of group A using a website}

\item{grp_b}{vector (usually corresponds to a column in a webtrack
data frame) indicating the number of individuals of group B using a website}
}
\description{
Symmetric Atkinson Index
calculates the symmetric Atkinson index
}
\examples{
# perfect score
grp_a <- c(5, 5, 0, 0)
grp_b <- c(0, 0, 5, 5)
atkinson_index(grp_a, grp_b)

grp_a <- c(5, 5, 5, 5)
grp_b <- c(5, 5, 5, 5)
atkinson_index(grp_a, grp_b)
}
\references{
Frankel, David, and Oscar Volij. "Scale Invariant Measures of Segregation "Working Paper, 2008.
}
