% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indices.R
\name{dissimilarity_index}
\alias{dissimilarity_index}
\title{Dissimilarity Index}
\usage{
dissimilarity_index(grp_a, grp_b)
}
\arguments{
\item{grp_a}{vector (usually corresponds to a column in a webtrack
data frame) indicating the number of individuals of group A using a website}

\item{grp_b}{vector (usually corresponds to a column in a webtrack
data frame) indicating the number of individuals of group B using a website}
}
\description{
The Dissimilarity Index can be interpreted as the share of Group A
visits that would need to be redistributed across media for the share of
group A to be uniform across websites.
}
\examples{
# perfect dissimilarity
grp_a <- c(5, 5, 0, 0)
grp_b <- c(0, 0, 5, 5)
dissimilarity_index(grp_a, grp_b)

# no dissimilarity
grp_a <- c(5, 5, 5, 5)
grp_b <- c(5, 5, 5, 5)
dissimilarity_index(grp_a, grp_b)
}
\references{
Cutler, David M., Edward L. Glaeser, and Jacob L. Vigdor. "The rise and decline of the American ghetto." Journal of political economy 107.3 (1999): 455-506.
}
