% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_player.R
\name{wnba_playernextngames}
\alias{wnba_playernextngames}
\title{\strong{Get WNBA Stats API Player Next N Games}}
\usage{
wnba_playernextngames(
  league_id = "10",
  number_of_games = 2147483647,
  player_id = "1628932",
  season = most_recent_wnba_season() - 1,
  season_type = "Regular Season",
  ...
)
}
\arguments{
\item{league_id}{League - default: '00'. Other options include '10': WWNBA, '20': G-League}

\item{number_of_games}{N in number of games}

\item{player_id}{Player ID}

\item{season}{Season - format 2020-21}

\item{season_type}{Season Type - Regular Season, Playoffs, All-Star}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Return a named list of data frames: NextNGames

\strong{NextNGames}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   GAME_DATE \tab character \cr
   HOME_TEAM_ID \tab character \cr
   VISITOR_TEAM_ID \tab character \cr
   HOME_TEAM_NAME \tab character \cr
   VISITOR_TEAM_NAME \tab character \cr
   HOME_TEAM_ABBREVIATION \tab character \cr
   VISITOR_TEAM_ABBREVIATION \tab character \cr
   HOME_TEAM_NICKNAME \tab character \cr
   VISITOR_TEAM_NICKNAME \tab character \cr
   GAME_TIME \tab character \cr
   HOME_WL \tab character \cr
   VISITOR_WL \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Player Next N Games}

\strong{Get WNBA Stats API Player Next N Games}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_playernextngames(player_id = '1628932', season = most_recent_wnba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Player Functions: 
\code{\link{wnba_infographicfanduelplayer}()},
\code{\link{wnba_leaguedashplayerbiostats}()},
\code{\link{wnba_leaguedashplayerclutch}()},
\code{\link{wnba_leaguedashplayershotlocations}()},
\code{\link{wnba_leaguedashplayerstats}()},
\code{\link{wnba_leagueplayerondetails}()},
\code{\link{wnba_leagueseasonmatchups}()},
\code{\link{wnba_playerawards}()},
\code{\link{wnba_playercareerbycollegerollup}()},
\code{\link{wnba_playercareerbycollege}()},
\code{\link{wnba_playercareerstats}()},
\code{\link{wnba_playercompare}()},
\code{\link{wnba_playerdashboardbyclutch}()},
\code{\link{wnba_playerdashboardbygamesplits}()},
\code{\link{wnba_playerdashboardbygeneralsplits}()},
\code{\link{wnba_playerdashboardbylastngames}()},
\code{\link{wnba_playerdashboardbyopponent}()},
\code{\link{wnba_playerdashboardbyshootingsplits}()},
\code{\link{wnba_playerdashboardbyteamperformance}()},
\code{\link{wnba_playerdashboardbyyearoveryear}()},
\code{\link{wnba_playerestimatedmetrics}()},
\code{\link{wnba_playerfantasyprofilebargraph}()},
\code{\link{wnba_playerfantasyprofile}()},
\code{\link{wnba_playergamelogs}()},
\code{\link{wnba_playergamelog}()},
\code{\link{wnba_playergamestreakfinder}()},
\code{\link{wnba_playerheadshot}()},
\code{\link{wnba_playerindex}()},
\code{\link{wnba_playerprofilev2}()},
\code{\link{wnba_playervsplayer}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Player Functions}
