% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_functions.R
\name{plot_pop}
\alias{plot_pop}
\title{Add Population Line to an Existing Grid}
\usage{
plot_pop(p_obj, x, params, distribution = c("weibull", "lognormal",
  "loglogistic"), color = I("#FF0000"), title_trace = "Population")
}
\arguments{
\item{p_obj}{a plotly object, which at least includes the layout provided
by \code{\link{plot_layout}}.}

\item{x}{a numeric vector containing the x-coordinates of the population line.}

\item{params}{a (named) numeric vector, where the first entry is the location
parameter \eqn{\mu} and the second entry is the scale parameter \eqn{\sigma}
of a lognormal or loglogistic distribution. If the distribution value is
\code{"weibull"} the first entry must be the scale parameter \eqn{\eta} and
the second entry must be the shape parameter \eqn{\beta}. Parametrization
is the same used in \code{\link{rweibull}}.}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"} or \code{"loglogistic"}.
Other distributions have not been implemented yet.}

\item{color}{the color of the population line should be added as follows:
For hexadecimal codes: \code{color = I("#3C8DBC")} and for a color specified
with a string: \code{color = I("blue")}.}

\item{title_trace}{a character string which is assigned to the trace shown in
the legend.}
}
\value{
A plotly object which contains the supposed linearized population
  CDF. Failure probabilities must be strictly below 1 and for this very reason
}
\description{
This function adds a linearized CDF to an existing plotly grid.
}
\examples{
x <- rweibull(n = 100, shape = 1, scale = 20000)
grid_weibull <- plot_layout(x = x,
                            distribution = "weibull",
                            title_main = "Weibull Analysis",
                            title_x = "Time to Failure",
                            title_y = "Failure Probability")
pop_weibull <- plot_pop(p_obj = grid_weibull,
                        x = x, params = c(20000, 1),
                        distribution = "weibull", color = I("green"),
                        title_trace = "Population")

}
