% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probability_estimators.R
\name{estimate_cdf}
\alias{estimate_cdf}
\alias{estimate_cdf.wt_reliability_data}
\title{Estimation of Failure Probabilities}
\usage{
estimate_cdf(x, ...)

\method{estimate_cdf}{wt_reliability_data}(
  x,
  methods = c("mr", "johnson", "kaplan", "nelson"),
  options = list(),
  ...
)
}
\arguments{
\item{x}{A tibble returned by \link{reliability_data}.}

\item{...}{Further arguments passed to or from other methods. Currently not used.}

\item{methods}{One or multiple methods of \code{"mr"}, \code{"johnson"},
\code{"kaplan"} or \code{"nelson"} used for the estimation of failure
probabilities. See 'Details'.}

\item{options}{A list of named options. See 'Options'.}
}
\value{
A tibble containing the following columns:
\itemize{
  \item \code{id} : Identification for every unit.
  \item \code{x} : Lifetime characteristic.
  \item \code{status} : Binary data (0 or 1) indicating whether a unit is a
    right censored observation (= 0) or a failure (= 1).
  \item \code{rank} : The (computed) ranks. Determined for methods \code{"mr"}
    and \code{"johnson"}, filled with \code{NA} for other methods or if
    \code{status = 0}.
  \item \code{prob} : Estimated failure probabilities, \code{NA} if \code{status = 0}.
  \item \code{cdf_estimation_method} : Specified method for the estimation of
    failure probabilities.
}
}
\description{
This function applies a non-parametric method to estimate the failure
probabilities of complete data taking (multiple) right-censored observations
into account.
}
\details{
One or multiple techniques can be used for the \code{methods} argument:
\itemize{
  \item \code{"mr"} : Method \emph{Median Ranks} is used to estimate the failure
    probabilities of failed units without considering censored items.
    Tied observations can be handled in three ways (See 'Options'):
    \itemize{
      \item \code{"max"} : Highest observed rank is assigned to tied observations.
      \item \code{"min"} : Lowest observed rank is assigned to tied observations.
      \item \code{"average"} : Mean rank is assigned to tied observations.
    }
    Two formulas can be used to determine cumulative failure probabilities
    \emph{F(t)} (See 'Options'):
    \itemize{
      \item \code{"benard"} : Benard's approximation for Median Ranks.
      \item \code{"invbeta"} : Exact Median Ranks using the inverse beta distribution.
    }
  \item \code{"johnson"} : The \emph{Johnson} method is used to estimate the
    failure probabilities of failed units, taking censored units into account.
    Compared to complete data, correction of probabilities is done by the
    computation of adjusted ranks.
  \item \code{"kaplan"} : The method of \emph{Kaplan} and \emph{Meier} is used
    to estimate the survival function \emph{S(t)} with respect to (multiple)
    right censored data. The complement of \emph{S(t)}, i.e. \emph{F(t)}, is
    returned. In contrast to the original \emph{Kaplan-Meier} estimator, one
    modification is made (see 'References').

    \strong{Note} : The \emph{Kaplan-Meier} estimator does not assign ranks to
    observations, so the beta-binomial confidence intervals \emph{cannot} be
    calculated using this method.
  \item \code{"nelson"} : The \emph{Nelson-Aalen} estimator models the cumulative
    hazard rate function in case of (multiple) right censored data. Equating the
    formal definition of the hazard rate with that according to \emph{Nelson-Aalen}
    results in a formula for the calculation of failure probabilities.

    \strong{Note} : The \emph{Nelson-Aalen} estimator does not assign ranks to
    observations, so the beta-binomial confidence intervals \emph{cannot} be
    calculated using this method.
}
}
\section{Options}{

The listed options can only be applied for method \code{"mr"}:
\itemize{
  \item \code{mr_method} : \code{"benard"} (default) or \code{"invbeta"}.
  \item \code{mr_ties.method} : \code{"max"} (default), \code{"min"} or \code{"average"}.
}
}

\examples{
# Reliability data:
data <- reliability_data(
  alloy,
  x = cycles,
  status = status
)

# Example 1 - Johnson method:
prob_tbl <- estimate_cdf(
  x = data,
  methods = "johnson"
)

# Example 2 - Multiple methods:
prob_tbl_2 <- estimate_cdf(
  x = data,
  methods = c("johnson", "kaplan", "nelson")
)

# Example 3 - Method 'mr' with options:
prob_tbl_3 <- estimate_cdf(
  x = data,
  methods = "mr",
  options = list(
    mr_method = "invbeta",
    mr_ties.method = "average"
  )
)

# Example 4 - Multiple methods and option for 'mr':
prob_tbl_4 <- estimate_cdf(
  x = data,
  methods = c("mr", "johnson"),
  options = list(
    mr_ties.method = "max"
  )
)

}
\references{
\emph{NIST/SEMATECH e-Handbook of Statistical Methods},
\emph{8.2.1.5. Empirical model fitting - distribution free (Kaplan-Meier) approach},
\href{https://www.itl.nist.gov/div898/handbook/apr/section2/apr215.htm}{NIST SEMATECH},
December 3, 2020
}
