\name{JensenAngle}
\alias{JensenAngle}

\title{For a given distance \code{x}, computes the wake cone generated by a turbine.}

\description{
In Jensen's wake model, a wake cone is generated by a turbine based on the turbine's hub height z, its rotor radius r_0, the terrain's roughness length z_0 and the distance x between the turbine under investigation and a certain second point. z, r_0 and z_0 are taken from the \code{\link{FarmVars}} settings object, while x is to be provided.
}

\usage{
JensenAngle(x)
}

\arguments{
	\item{x}{
		must be a single value. Provide distance in meters.
	}
}

\details{
If a second turbine (B) is in a first turbine (A)'s wake, turbine B's power output must be penalized due to turbulence. This can be performed via Jensen's wake model, but first, it should be checked whether B is actually in A's wake. This function computes the angle of the wake cone generated by turbine A. This can be used together with function \code{\link{JensenTrapezoid}} \code{\link{PointInPolygon}} and  to see if B is in the wake of A.
}

\value{
\code{JensenAngle} returns the (onesided) angle of the wake cone generated by a turbine for distance \code{x}.
}

\references{
Jensen, N. O. (1983). A note on wind generator interaction. Roskilde: Risø National Laboratory. Risø-M, No. 2411
}

\author{
Carsten Croonenbroeck
}

\seealso{
\code{\link{JensenTrapezoid}} to check whether there are wake effects present. \code{\link{FarmVars}} for the data object.
}

\examples{
JensenAngle(500)
## For a distance of 500 m, the function returns a wake cone angle of 9.2233 degrees
## (given standard values for z, z_0 and r_0 in the FarmVars settings object).
}

\keyword{Jensen}
\keyword{Profit}
