% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/whibo_clustering.R
\name{whibo_clustering}
\alias{whibo_clustering}
\title{Find Cluster model using White-Box Cluster Algorithm Design.}
\usage{
whibo_clustering(data, k = 3, normalization_type = "No",
  cluster_initialization_type = "Random", assignment_type = "Euclidean",
  recalculation_type = "Mean", max_iteration = 20, no_of_restarts = 1)
}
\arguments{
\item{data}{Data on which clustering should be performed.}

\item{k}{Number of Cluster Representatives.}

\item{normalization_type}{Which normalization should be used (look at \code{wc_norm_types} for possible values). Default value is \code{No}.}

\item{cluster_initialization_type}{Which initialization of Cluster Representatives should be used (look at \code{wc_init_types} for possible values). Default value is \code{Random}.}

\item{assignment_type}{Which assignment function should be used (look at \code{wc_assign_types} for possible values). Default value is \code{Euclidean}.}

\item{recalculation_type}{Which function for updating Cluster Representatives should be used (look at \code{wc_recalculate_types} for possible values). Default value is \code{Mean}.}

\item{max_iteration}{Number of iterations. Default value is 20.}

\item{no_of_restarts}{Number of restarts of whole clustering procedure. Default value is 1.}
}
\value{
Object of type \code{whibo_cluster} which include Cluster Representatives (\code{centroids}), number of elements per cluster (\code{elements_per_cluster}), assignments (\code{assignments}), measures of cluster quality (\code{within_sum_of_squares}, \code{between_ss_div_total_ss} and \code{internal_measures_of_quality}), cluster models per iterations (\code{model_history}), iterations (\code{iterations}) and parameters used (\code{params})
}
\description{
Find Cluster model using White-Box Cluster Algorithm Design.
}
\examples{
data <- iris[, 1:4] #Take only numerical columns

#Perform k-means clustering
model <- whibo_clustering(data = data, k = 3)
model

#Perform some unorthodox clustering
model <- whibo_clustering(data = data, k = 3,
     normalization_type = 'Z', cluster_initialization_type = 'Ward',
     assignment_type = 'Correlation', recalculation_type = 'Trimean')

}
\seealso{
\code{plot.whibo_cluster}, \code{predict.whibo_cluster}
}
\author{
Sandro Radovanovic \email{sandro.radovanovic@gmail.com}
}
