% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_tools.R
\name{wbt_remove_raster_polygon_holes}
\alias{wbt_remove_raster_polygon_holes}
\title{Remove raster polygon holes}
\usage{
wbt_remove_raster_polygon_holes(
  input,
  output,
  threshold = 3,
  use_diagonals = TRUE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input raster image file.}

\item{output}{Name of the output raster file.}

\item{threshold}{Maximum size of removed holes, in grid cells. Blank for no threshold, i.e. remove all holes.}

\item{use_diagonals}{Use diagonal neighbours during clumping operation.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Removes polygon holes, or 'donut-holes', from raster polygons.
}
\keyword{DataTools}
