% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hydro_analysis.R
\name{wbt_impoundment_size_index}
\alias{wbt_impoundment_size_index}
\title{Impoundment size index}
\usage{
wbt_impoundment_size_index(
  dem,
  damlength,
  out_mean = NULL,
  out_max = NULL,
  out_volume = NULL,
  out_area = NULL,
  out_dam_height = NULL,
  wd = NULL,
  verbose_mode = NULL,
  compress_rasters = NULL,
  command_only = FALSE
)
}
\arguments{
\item{dem}{Input raster DEM file.}

\item{damlength}{Maximum length of the dam.}

\item{out_mean}{Output mean flooded depth file.}

\item{out_max}{Output maximum flooded depth file.}

\item{out_volume}{Output flooded volume file.}

\item{out_area}{Output flooded area file.}

\item{out_dam_height}{Output dam height file.}

\item{wd}{Changes the working directory. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_wd()} for details.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_verbose()} for details.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters. Default: \code{NULL} will use the value in WhiteboxTools settings, see \code{wbt_compress_rasters()} for details.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool. Default: \code{FALSE}.}
}
\value{
Returns the tool text outputs.
}
\description{
Calculates the impoundment size resulting from damming a DEM.
}
\keyword{HydrologicalAnalysis}
