% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{estimate_m_rd}
\alias{estimate_m_rd}
\title{Estimate heterozygote miscall rate for different read depth categories (no nulls)}
\usage{
estimate_m_rd(Y, R, init_m, num_cats, p_prior, m_prior, num_reps)
}
\arguments{
\item{Y}{the 012,-1 matrix that is N x L giving the observed genotypes of the N individuals
at L SNPs.}

\item{R}{integer matrix that is N x L giving the read depth categories.  These must be indexed from
1 up to num_cats.  Missing data should be -1.}

\item{init_m}{starting value for m.  Typically you might want to use the m estimated
from init_m}

\item{num_cats}{the number of read depth categories.}

\item{p_prior}{two-vector that holds the beta parameters for a prior on the
allele frequency for each locus.  Typical value is c(0.5, 0.5).}

\item{m_prior}{two-vector that holds the beta parameters for a prior on the
heterozygote miscall rate for each locus.  Typical value is c(0.5, 0.5).}

\item{num_reps}{the number of MCMC sweeps to do.}
}
\description{
To see how this Rcpp function is applied, see the code in
\code{\link{infer_m}}.
}
\keyword{internal}
