% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/helper_rowSums.R
\name{helper_rowSums}
\alias{helper_rowSums}
\title{Perform row sum}
\usage{
helper_rowSums(x, allNA0 = TRUE, ...)
}
\arguments{
\item{x}{an array of two or more dimensions, containing numeric, complex, integer or logical values, or a numeric data frame}

\item{allNA0}{logical indicating that if a whole row is NA to give the row sum as NA. Only works for two dimensional \code{x} and if \code{na.rm} is \code{TRUE}.}

\item{...}{other arguments to pass to \code{base::rowSums()}}
}
\value{
A numeric or complex array of suitable size, or a vector if the result is one-dimensional.
}
\description{
Perform row sum
}
\details{
Essentially equivalent to \code{base::rowSums()} except with the addition of the \code{allNA0} argument.
}
\examples{
x <- data.frame(v1 = c(NA,1:4), v2 = c(NA, 2:5), v3 = c(NA, 1:2, NA, 3))
helper_rowSums(x, na.rm = TRUE, allNA0 = TRUE)
helper_rowSums(x, na.rm = TRUE, allNA0 = FALSE)
}
