% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/widely_svd.R
\name{widely_svd}
\alias{widely_svd}
\alias{widely_svd_}
\title{Turn into a wide matrix, perform SVD, return to tidy form}
\usage{
widely_svd(tbl, item, feature, value, nv = NULL, weight_d = FALSE, ...)

widely_svd_(tbl, item, feature, value, nv = NULL, weight_d = FALSE, ...)
}
\arguments{
\item{tbl}{Table}

\item{item}{Item to perform dimensionality reduction on; will end up in \code{item} column}

\item{feature}{Column describing the feature that links one item to others.}

\item{value}{Value}

\item{nv}{Optional; the number of principal components to estimate. Recommended for matrices
with many features.}

\item{weight_d}{Whether to multiply each value by the \code{d} principal component.}

\item{...}{Extra arguments passed to \code{svd} (if \code{nv} is \code{NULL})
or \code{irlba} (if \code{nv} is given)}
}
\value{
A tbl_df with three columns. The first is retained from the \code{item} input,
then \code{dimension} and \code{value}. Each row represents one principal component
value.
}
\description{
This is useful for dimensionality reduction of items, especially when setting a
lower nv.
}
\examples{

library(dplyr)
library(gapminder)

# principal components driving change
gapminder_svd <- gapminder \%>\%
  widely_svd(country, year, lifeExp)

gapminder_svd

# compare SVDs, join with other data
library(ggplot2)
library(tidyr)

gapminder_svd \%>\%
  spread(dimension, value) \%>\%
  inner_join(distinct(gapminder, country, continent), by = "country") \%>\%
  ggplot(aes(`1`, `2`, label = country)) +
  geom_point(aes(color = continent)) +
  geom_text(vjust = 1, hjust = 1)

}
