% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikiTools.R
\name{getWikiInf}
\alias{getWikiInf}
\title{Create a data.frame with Q's and descriptions of a vector of names.}
\usage{
getWikiInf(names, number = 1, language = "en")
}
\arguments{
\item{names}{A vector consisting of one or more Wikidata's entry (i.e., topic or person).}

\item{number}{Take the number occurrence in case there are several equal names in Wikidata.}

\item{language}{The language of the Wikipedia page version. This should consist of an ISO language code (default = "en").}
}
\value{
A data frame with name, Q, label and description of the names.
}
\description{
Create a data.frame with Q's and descriptions of a vector of names.
}
\examples{
## Obtaining information in English Wikidata
names <- c("William Shakespeare", "Pablo Picasso")
information <- getWikiInf(names)

## Obtaining information in Spanish Wikidata
\dontrun{
informacion <- getWikiInf(names, language="es")
}
}
\author{
Modesto Escobar, Department of Sociology and Communication, University of Salamanca. See \url{https://sociocav.usal.es/blog/modesto-escobar/}
}
