% Generated by roxygen2 (4.0.1): do not edit by hand
\name{IAB}
\alias{IAB}
\title{Benhamou's IAB Index}
\usage{
IAB(traj1, traj2, tc = 0, dc = 50, local = FALSE)
}
\arguments{
\item{traj1}{an object of the class \code{ltraj} which contains the time-stamped
movement fixes of the first object. Note this object must be a \code{type II
ltraj} object. For more information on objects of this type see \code{help(ltraj)}.}

\item{traj2}{same as \code{traj1}.}

\item{tc}{time threshold for determining simultaneous fixes -- see function: \code{GetSimultaneous}.}

\item{dc}{critical distance where the IAB function will show maximium slope -- see Benhamou et al. (2014)
for more advice on selecting this parameter.}

\item{local}{logical value indicating whether a dataframe (\code{local = TRUE}) containing the IAB
   index for each simultaneous fix should be returned, or (if \code{local = FALSE} - the default)
   the global index along with associated p-value.}
}
\value{
If \code{local=FALSE} (the default) IAB returns the numeric value of the IAB index and the associated p-value.
If \code{local=TRUE} IAB returns a dataframe (containing the date/times of \emph{all} simultaneous fixes,
along with the distance between fixes at each time, and the IAB index value for each simultaneous fix.
}
\description{
The function \code{IAB} computes the IAB index following the methods described in the paper by
Benhamou et al. (2014). It facilitates global analysis, with the significance testing procedure
described in the paper, but also a local level output, to explore the IAB statistic through time.
}
\details{
The function \code{IAB} can be used to test for direct interaction in wildlife telemetry data and affords
a novel significance testing procedure that takes into account the serially correlated structure of
telemetry data. Specifically, it computes an index analogous to the Bhattacharyya coefficient between the
potential influence domains of two animals. Like the other indices, IAB is dependent on the selection of an
appropriate value for \code{dc} (which is termed \eqn{\Delta}{Delta} in the article). The \code{dc} parameter here is
not a threshold distance, but rather the distance at which the function shows maximum slope (see
Benhamou et al. 2014).

The significance testing procuedure uses a wrapped shifting method in order to maintain the serially correlated
structure of the data. At each shift, a sample value of IAB (termed MAB) is computed in order to generate
a distribution of values to test against (for more information see Benhamou et al. 2014).
}
\examples{
data(deer)
deer37 <- deer[1]
deer38 <- deer[2]
#tc = 7.5 minutes, dc = 50 meters
IAB(deer37, deer38, tc=7.5*60, dc=50)
df <- IAB(deer37, deer38, tc=7.5*60, dc=50, local=TRUE)
}
\references{
Benhamou, S., Valeix, M., Chamaille-Jammes, S., Macdonald, D., Loveridge, A.J. (2014) Movement-based analysis
of interactions in African lions. \emph{Animal Behaviour}, \bold{90}: 171-180.
}
\seealso{
GetSimultaneous, DI, Prox
}
\keyword{indices}

