% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conPhase.R
\name{conPhase}
\alias{conPhase}
\title{Process contact phases}
\usage{
conPhase(ltraj, pc = 0, idcol = "burst")
}
\arguments{
\item{ltraj}{an object of the class \code{ltraj} which is output from the function \code{conProcess}.}

\item{pc}{time (in seconds) to allow for which to combine contact events (see details).}

\item{idcol}{column used to identify individuals (default is the burst)}
}
\value{
An \code{ltraj} object with new column \code{contact_pha}.
}
\description{
Computes phases where contacts occur based on a temporal tolerance.
}
\details{
This function is used following the \code{conProcess} function to arrange contacts into phases where continuous contact occurs (based on the user-defined time threshold \code{pc}. The idea is that we can consider a phase to be a continuous contact event (based on \code{dc} see \code{conProcess}) as long as the contact is only interrupted for no more than \code{pc} time units.
}
\examples{
\dontrun{
data(does)
doecons <- conProcess(does,tc=15*60,dc=50)
doephas <- conPhase(doecons,pc=60*60)
}

}
\references{
Long, JA, Webb, SL, Harju, SM, Gee, KL (2022) Analyzing Contacts and Behavior from High Frequency 
 Tracking Data Using the wildlifeDI R Package. \emph{Geographical Analysis}. \bold{54}, 648--663.
}
\seealso{
conProcess, conSpatial, conTemporal, conSummary
}
\keyword{contacts}
