% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetTO.r
\name{GetTO}
\alias{GetTO}
\title{Get period where two tracks overlap}
\usage{
GetTO(traj, tb = 0)
}
\arguments{
\item{traj}{an object of the class \code{move2} which contains the time-stamped movement fixes of >= 1 individual. For more information on objects of this type see \code{help(mt_as_move2)}.}

\item{tb}{(optional) time threshold (i.e., time buffer) for considering if fixes are in the overlap period (in seconds).}
}
\value{
A single \code{move2} object containing the fixes from traj that temporally overlap. If more than 2 individuals it will take the maximum of the earliest start-time from all individuals and minimum of the latest end-time of all individuals.
}
\description{
The function \code{GetTO} identifies and extracts fixes of a tracking dataset that overlap in time with all other trajectories.
}
\details{
This function is used to determine the fixes that overlap in time between two trajectories.
}
\examples{
data(deer)
deer_to <- GetTO(deer)

}
\seealso{
checkTO
}
\keyword{processing}
