% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rwolf_sim.R
\name{run_fwer_sim}
\alias{run_fwer_sim}
\title{Family Wise Error Rate Simulations}
\usage{
run_fwer_sim(
  n_sims = 100,
  rho = c(0, 0.25, 0.5, 0.75),
  seed = 114411,
  B = 499,
  N = 1000,
  s = 6,
  G = 20
)
}
\arguments{
\item{n_sims}{The number of Monte Carlo iterations. 100 by default.}

\item{rho}{The correlation between the outcome variables. Vectorized 
c(0, 0.25, 0.5, .75) by default}

\item{seed}{A random seed.}

\item{B}{The number of bootstrap draws. 499 by default.}

\item{N}{The number of observations. 1000 by default.}

\item{s}{The number of dependent variables. 6 by default.}

\item{G}{The number of clusters. If NULL, no clustering. 20 by default}
}
\value{
A data frame containing familiy wise rejection rates for uncorrected 
pvalues and corrected pvalues using Holm's and the Romano-Wolf method.

\item{reject_5}{The family wise rejection rate at a 5\%  level}
\item{reject_10}{The family wise rejection rate at a 10\%  level}
\item{rho}{The correlation between the outcome variables. See function
 argument`rho` for more information.}
}
\description{
Run a MC simulation study on family-wise error rates (FWERs)
for the Holm and Romano & Wolf Methods multiple
hypothesis adjustment methods given true null effects
}
\examples{
\donttest{

# N, B, n_sims, chosen so that the example runs quicker
# for a higher quality simulation, increase all values
res <- run_fwer_sim(
  seed = 123,
  n_sims = 10,
  B = 199,
  N = 100,
  s = 10, 
  rho = 0
)

}
}
