% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prep_aqi.R
\name{get_state_code}
\alias{get_state_code}
\title{Get state code from the state names.}
\usage{
get_state_code(aqs_api_email, aqs_api_key, state_names)
}
\arguments{
\item{aqs_api_email}{AQS API email}

\item{aqs_api_key}{AQS API key}

\item{state_names}{A vector containing state names.}
}
\value{
A vector of state code per state name provided.
}
\description{
Get state code from the state names.
}
\note{
The function uses the AQS API to fetch the data from the API endpoints. Use the following service to register as a user:
A verification email will be sent to the email account specified. To register using the email address
create and request this link (Replace \email{myemail@example.com} in the example with your email address.):
(\url{https://aqs.epa.gov/data/api/signup?email=myemail@example.com})
You then need to set the email and the key in the .Renviron file as follows, i.e.
aqs_api_email=\email{myemail@example.com}
aqs_api_key=testkey1234
}
\examples{
\dontrun{
aqs_api_email = Sys.getenv('aqs_api_email')
aqs_api_key = Sys.getenv('aqs_api_key')

state_codes <- get_state_code(aqs_api_email = aqs_api_email,
                              aqs_api_key = aqs_api_key,
                              state_names = c('California', 'New York'))
}

}
