% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_trace_back.R
\name{winch_add_trace_back}
\alias{winch_add_trace_back}
\title{Enrich an rlang traceback with details on native calls}
\usage{
winch_add_trace_back(trace = rlang::trace_back(bottom = parent.frame()))
}
\arguments{
\item{trace}{An rlang traceback as returned by \code{\link[rlang:trace_back]{rlang::trace_back()}}.}
}
\description{
This function uses the native stack trace returned from \code{\link[=winch_trace_back]{winch_trace_back()}}
to add details on native function calls to an rlang traceback object.
It is intended to be called by rlang.
}
\examples{
\dontshow{if (requireNamespace("rlang", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
foo <- function() {
  winch_call(bar)
}

bar <- function() {
  trace <- rlang::trace_back()
  winch_add_trace_back(trace)
}

foo()
\dontshow{\}) # examplesIf}
}
