% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hullMuirAreaCorrection.R
\name{hullMuirAreaCorrection}
\alias{hullMuirAreaCorrection}
\title{Calculate an area correction based on the Hull and Muir (2010) maximum
  distance}
\usage{
hullMuirAreaCorrection(hubHeight, bladeRadius, lowerBound = 0,
  proportionSearchDF, distanceCol, proportionCol, additionalCol = NULL,
  ...)
}
\arguments{
\item{hubHeight}{Numeric, turbine hub height.}

\item{bladeRadius}{Numeric, turbine blade radius.}

\item{lowerBound}{Numeric, default is zero, see \code{\link{triangleProb}}.}

\item{proportionSearchDF}{Data frame with at least two columns: distance from
turbine and proportion of area searched at each distance.}

\item{distanceCol}{Character string indicating the distance column in
\code{proportionSearchDF}.}

\item{proportionCol}{Character string indicating the proportion column in
\code{proportionSearchDF}.}

\item{additionalCol}{Character vector, default is NULL, indicating additional
columns of how the area correction value should be calculated, see examples.}

\item{...}{Currently ignored.}
}
\value{
Data frame of size class, \code{additionalCol} columns, and area
  correction
}
\description{
Calculate the maximum fall distance from a turbine using the
  regression model from Hull and Muir (2010). Calculate the proabilities
  between one-unit increments of a right triangle distribution. Use the
  probabilities and proportion of area searched to calculate an area correction
  value.
}
\details{
The maximum Hull and Muir distances are calculated using
  \code{\link{hullMuirMaxDistance}} and the probabilities are calculated using
  \code{\link{triangleProb}}. The probabilites are multipled by the proportion
  of area searched from \code{proportionSearchDF} by distance. The products are
  summed by size class and \code{additionalCol}.

  The distances in the \code{distanceCol} will be rounded to the nearest
  integer for matching up with the probabilities. The distances, \code{hubHeight}, and \code{bladeRadius} are assumed to be in the same units.
}
\examples{

## proportion of area searched data
data(proportionAreaSearched)

hullMuirAreaCorrection(hubHeight = 87.5, bladeRadius = 62.5,
                       proportionSearchDF = proportionAreaSearched,
                       distanceCol = 'distanceFromTurbine',
                       proportionCol = 'proportionAreaSearched',
                       additionalCol = 'plotType')

## without additional columns but must separate the proportion of area searched
## data frame
hullMuirAreaCorrection(hubHeight = 87.5, bladeRadius = 62.5,
                       proportionSearchDF = subset(proportionAreaSearched, plotType == 'RP'),
                       distanceCol = 'distanceFromTurbine',
                       proportionCol = 'proportionAreaSearched')

hullMuirAreaCorrection(hubHeight = 87.5, bladeRadius = 62.5,
                       proportionSearchDF = subset(proportionAreaSearched, plotType == 'FULL'),
                       distanceCol = 'distanceFromTurbine',
                       proportionCol = 'proportionAreaSearched')
}
\references{
Hull, C. L., & Muir, S. (2010).
  Search areas for monitoring bird and bat carcasses at wind farms using a Monte-Carlo model.
  Australasian Journal of Environmental Management, 17(2), 77-87.
}
