% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/genetic_algorithm.R
\name{isSpatial}
\alias{isSpatial}
\title{Transform to SpatialPolygons}
\usage{
isSpatial(shape, proj)
}
\arguments{
\item{shape}{An area as SpatialPolygon, SimpleFeature Polygon or coordinates
as matrix/data.frame}

\item{proj}{Which Projection should be assigned to matrix / data.frame
coordinates}
}
\value{
A SpatialPolygons object
}
\description{
Helper Function, which transforms SimpleFeatures or coordinates
  in matrix/data.frame/data.table into a SpatialPolygon
}
\details{
If the columns are named, it will look for common abbreviation to
  match x/y or long/lat columns. If the columns are not named, the first 2
  numeric columns are taken.
}
\examples{
\donttest{
library(sp)
df <- rbind(c(4498482, 2668272), c(4498482, 2669343),
            c(4499991, 2669343), c(4499991, 2668272))
isSpatial(df)

Polygon1 <- Polygon(rbind(c(4498482, 2668272), c(4498482, 2669343),
                          c(4499991, 2669343), c(4499991, 2668272)))
Polygon1 <- Polygons(list(Polygon1), 1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+init=epsg:3035"
proj4string(Polygon1) <- CRS(Projection)
df_fort <- ggplot2::fortify(Polygon1)
isSpatial(df_fort, Projection)
}
}
\seealso{
Other Helper Functions: 
\code{\link{dup_coords}()},
\code{\link{getDEM}()},
\code{\link{getISO3}()},
\code{\link{get_grids}()},
\code{\link{grid_area}()},
\code{\link{hexa_area}()},
\code{\link{permutations}()},
\code{\link{readintegerSel}()},
\code{\link{readinteger}()},
\code{\link{splitAt}()},
\code{\link{tess2SPdf}()},
\code{\link{windata_format}()}
}
\concept{Helper Functions}
