% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plots.R
\name{plot_leaflet}
\alias{plot_leaflet}
\title{Plot a wind warm with leaflet}
\usage{
plot_leaflet(result, Polygon1, which = 1, orderitems = TRUE, GridPol)
}
\arguments{
\item{result}{The output of \code{\link{windfarmGA}} or
\code{\link{genetic_algorithm}}}

\item{Polygon1}{The considered area as SpatialPolygon, SimpleFeature Polygon
or coordinates as matrix/data.frame}

\item{which}{A numeric value, indicating which individual to plot. The
default is 1. Combined with \code{orderitems = TRUE} this will show the 
best performing wind farm.}

\item{orderitems}{A logical value indicating whether the results should be
ordered by energy values \code{TRUE} or chronologically \code{FALSE}}

\item{GridPol}{By default, the grid will be calculated based on the inputs 
of \code{result} and the \code{Polygon1}. But another spatial object or the 
output of the  \code{\link{grid_area}} or \code{\link{hexa_area}} functions 
can also be}
}
\value{
Returns a leaflet map.
}
\description{
Plot a resulting wind farm on a leaflet map.
}
\examples{
\donttest{
## Plot the best wind farm on a leaflet map (ordered by energy values)
plot_leaflet(result = resulthex, Polygon1 = sp_polygon, which = 1)

## Plot the last wind farm (ordered by chronology).
plot_leaflet(result = resulthex, Polygon1 = sp_polygon, orderitems = FALSE,
         which = 1)
         
## Plot the best wind farm on a leaflet map with the rectangular Grid
Grid <- grid_area(sp_polygon, size = 150, prop = 0.4)
plot_leaflet(result = resultrect, Polygon1 = sp_polygon, which = 1, 
             GridPol = Grid[[2]])

## Plot the last wind farm with hexagonal Grid
Grid <- hexa_area(sp_polygon, size = 75)
plot_leaflet(result = resulthex, Polygon1 = sp_polygon, which = 1, 
             GridPol = Grid[[2]])
}
}
