% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_winfapapi.R
\name{get_amax}
\alias{get_amax}
\title{A function to obtain annual maxima (AMAX) data using the NRFA API}
\usage{
get_amax(station)
}
\arguments{
\item{station}{the NRFA station number for which the annual maxima records should be obtained. Can also be a vector of station numbers.}
}
\value{
a data.frame with information on the annual maxima for the station with the following columns
\describe{
 \item{Station}{NRFA station number (can be a vector of station numbers)}
 \item{WaterYear}{the correct water year for the peak flow}
 \item{Date}{date of maximum flow}
 \item{Flow}{the maximum flow in m3/s}
 \item{Stage}{the stage (height) reached by the river - this information is used to derive the flow via a rating curve}
 \item{Rejected}{logical, if TRUE the water year has been flagged as rejected by the NRFA}
}
}
\description{
The function queries the NRFA API for the .AM file similar to the WINFAP file for a given stations. It then processes the file in a fashion similar to \code{read_amax}.
}
\examples{
  a40003 <- get_amax(40003) # the Medway at Teston / East Farleigh
  multipleStations <- get_amax(c(40003, 42003))
  names(multipleStations)
  summary(multipleStations$`42003`)
}
\seealso{
\code{\link{read_amax}}. Information on river flow gauging in the UK and the annual maxima can be found at the National River Flow Archive website \url{https://nrfa.ceh.ac.uk}
}
